/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.listener;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.common.IPredicate;
import net.engio.mbassy.common.ReflectionUtils;
import net.engio.mbassy.listener.Enveloped;
import net.engio.mbassy.listener.Filter;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.listener.Listener;
import net.engio.mbassy.listener.MessageHandlerMetadata;
import net.engio.mbassy.listener.MessageListenerMetadata;
import net.engio.mbassy.subscription.MessageEnvelope;

public class MetadataReader {
    private static final IPredicate<Method> AllMessageHandlers = new IPredicate<Method>(){

        @Override
        public boolean apply(Method target) {
            return target.getAnnotation(Listener.class) != null;
        }
    };
    private final Map<Class<? extends IMessageFilter>, IMessageFilter> filterCache = new HashMap<Class<? extends IMessageFilter>, IMessageFilter>();

    private IMessageFilter[] getFilter(Listener subscription) {
        if (subscription.filters().length == 0) {
            return null;
        }
        IMessageFilter[] filters = new IMessageFilter[subscription.filters().length];
        int i = 0;
        for (Filter filterDef : subscription.filters()) {
            IMessageFilter filter = this.filterCache.get(filterDef.value());
            if (filter == null) {
                try {
                    filter = filterDef.value().newInstance();
                    this.filterCache.put(filterDef.value(), filter);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            filters[i] = filter;
            ++i;
        }
        return filters;
    }

    public MessageHandlerMetadata getHandlerMetadata(Method messageHandler) {
        Listener config = messageHandler.getAnnotation(Listener.class);
        return new MessageHandlerMetadata(messageHandler, this.getFilter(config), config);
    }

    public List<MessageHandlerMetadata> getMessageHandlers(Class<?> target) {
        List<Method> allHandlers = ReflectionUtils.getMethods(AllMessageHandlers, target);
        LinkedList<Method> bottomMostHandlers = new LinkedList<Method>();
        for (Method handler : allHandlers) {
            if (ReflectionUtils.containsOverridingMethod(allHandlers, handler)) continue;
            bottomMostHandlers.add(handler);
        }
        LinkedList<MessageHandlerMetadata> filteredHandlers = new LinkedList<MessageHandlerMetadata>();
        for (Method handler : bottomMostHandlers) {
            Listener listener = handler.getAnnotation(Listener.class);
            if (!listener.enabled() || !this.isValidMessageHandler(handler)) continue;
            Method overriddenHandler = ReflectionUtils.getOverridingMethod(handler, target);
            MessageHandlerMetadata handlerMetadata = new MessageHandlerMetadata(overriddenHandler == null ? handler : overriddenHandler, this.getFilter(listener), listener);
            filteredHandlers.add(handlerMetadata);
        }
        return filteredHandlers;
    }

    public <T> MessageListenerMetadata<T> getMessageListener(Class<T> target) {
        return new MessageListenerMetadata<T>(this.getMessageHandlers(target), target);
    }

    private boolean isValidMessageHandler(Method handler) {
        if (handler == null || handler.getAnnotation(Listener.class) == null) {
            return false;
        }
        if (handler.getParameterTypes().length != 1) {
            System.out.println("Found no or more than one parameter in messageHandler [" + handler.getName() + "]. A messageHandler must define exactly one parameter");
            return false;
        }
        Enveloped envelope = handler.getAnnotation(Enveloped.class);
        if (envelope != null && !MessageEnvelope.class.isAssignableFrom(handler.getParameterTypes()[0])) {
            System.out.println("Message envelope configured but no subclass of MessageEnvelope found as parameter");
            return false;
        }
        if (envelope != null && envelope.messages().length == 0) {
            System.out.println("Message envelope configured but message types defined for handler");
            return false;
        }
        return true;
    }
}

