/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.common;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.engio.mbassy.common.IPredicate;

public class ReflectionUtils {
    public static List<Method> getMethods(IPredicate<Method> condition, Class<?> target) {
        LinkedList<Method> methods = new LinkedList<Method>();
        try {
            for (Method method : target.getDeclaredMethods()) {
                if (!condition.apply(method)) continue;
                methods.add(method);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!target.equals(Object.class)) {
            methods.addAll(ReflectionUtils.getMethods(condition, target.getSuperclass()));
        }
        return methods;
    }

    public static Method getOverridingMethod(Method overridingMethod, Class subclass) {
        Class current = subclass;
        while (!current.equals(overridingMethod.getDeclaringClass())) {
            try {
                Method overridden = current.getDeclaredMethod(overridingMethod.getName(), overridingMethod.getParameterTypes());
                return overridden;
            }
            catch (NoSuchMethodException e) {
                current = current.getSuperclass();
            }
        }
        return null;
    }

    public static List<Method> withoutOverridenSuperclassMethods(List<Method> allMethods) {
        LinkedList<Method> filtered = new LinkedList<Method>();
        for (Method method : allMethods) {
            if (ReflectionUtils.containsOverridingMethod(allMethods, method)) continue;
            filtered.add(method);
        }
        return filtered;
    }

    public static Collection<Class> getSuperclasses(Class from) {
        LinkedList<Class> superclasses = new LinkedList<Class>();
        while (!from.equals(Object.class)) {
            superclasses.add(from.getSuperclass());
            from = from.getSuperclass();
        }
        return superclasses;
    }

    public static boolean containsOverridingMethod(List<Method> allMethods, Method methodToCheck) {
        for (Method method : allMethods) {
            if (!ReflectionUtils.isOverriddenBy(methodToCheck, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverriddenBy(Method superclassMethod, Method subclassMethod) {
        if (superclassMethod.getDeclaringClass().equals(subclassMethod.getDeclaringClass()) || !superclassMethod.getDeclaringClass().isAssignableFrom(subclassMethod.getDeclaringClass()) || !superclassMethod.getName().equals(subclassMethod.getName())) {
            return false;
        }
        Class<?>[] superClassMethodParameters = superclassMethod.getParameterTypes();
        Class<?>[] subClassMethodParameters = superclassMethod.getParameterTypes();
        if (subClassMethodParameters.length != subClassMethodParameters.length) {
            return false;
        }
        for (int i = 0; i < subClassMethodParameters.length; ++i) {
            if (superClassMethodParameters[i].equals(subClassMethodParameters[i])) continue;
            return false;
        }
        return true;
    }
}

