/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.utils.properties;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.endrealm.realmdrive.annotations.IgnoreVar;
import net.endrealm.realmdrive.annotations.ReadOnly;
import net.endrealm.realmdrive.annotations.SaveAll;
import net.endrealm.realmdrive.annotations.SaveTable;
import net.endrealm.realmdrive.annotations.SaveVar;
import net.endrealm.realmdrive.annotations.WriteOnly;
import net.endrealm.realmdrive.utils.properties.ClassProperties;
import net.endrealm.realmdrive.utils.properties.FieldProperties;

public class PropertyReader {
    public static ClassProperties readProperties(Class<?> clazz) {
        SaveAll saveAll = clazz.getAnnotation(SaveAll.class);
        SaveTable saveTable = clazz.getAnnotation(SaveTable.class);
        String tableName = null;
        ArrayList<String> ignoredFields = new ArrayList<String>();
        boolean saveAllVariables = false;
        if (saveAll != null) {
            saveAllVariables = true;
            ignoredFields.addAll(Arrays.asList(saveAll.ignored()));
        }
        if (saveTable != null) {
            tableName = saveTable.tableName().equals("") ? null : saveTable.tableName();
        }
        return new ClassProperties(tableName, ignoredFields, saveAllVariables);
    }

    public static FieldProperties readProperties(Field field, ClassProperties classProperties) {
        IgnoreVar ignoreVar = field.getAnnotation(IgnoreVar.class);
        SaveVar saveVar = field.getAnnotation(SaveVar.class);
        ReadOnly readOnly = field.getAnnotation(ReadOnly.class);
        WriteOnly writeOnly = field.getAnnotation(WriteOnly.class);
        boolean write = false;
        boolean read = false;
        String name = field.getName();
        ArrayList<String> aliases = new ArrayList<String>();
        boolean optional = true;
        if (saveVar != null) {
            name = saveVar.name().equals("") ? field.getName() : saveVar.name();
            aliases.addAll(Arrays.asList(saveVar.aliases()));
            optional = saveVar.optional();
            read = true;
            write = true;
        }
        if (classProperties.isSaveAll()) {
            read = true;
            write = true;
        }
        if (readOnly != null) {
            read = true;
            write = false;
        }
        if (writeOnly != null) {
            write = true;
            read = false;
        }
        if (ignoreVar != null || classProperties.getIgnoredFields().contains(field.getName())) {
            read = false;
            write = false;
        }
        return new FieldProperties(write, read, name, aliases, optional);
    }
}

