/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.factory.DriveObjectFactory;
import net.endrealm.realmdrive.interfaces.DriveElement;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;

public class SimpleElementArray
implements DriveElementArray {
    private ArrayList<DriveElement> list;
    private final DriveObjectFactory factory;

    public SimpleElementArray(DriveObjectFactory factory) {
        this.factory = factory;
        this.list = new ArrayList();
    }

    @Override
    public DriveElement get(int num) {
        return this.list.get(num);
    }

    @Override
    public DriveObject getAsObject(int num) {
        return this.list.get(num) == null ? null : this.list.get(num).getAsObject();
    }

    @Override
    public void addObject(int num, DriveElement element) {
        this.list.add(num, element);
    }

    @Override
    public void addPrimitive(int num, Object object) throws NotAPrimitiveTypeException {
        this.addObject(num, this.factory.createPrimitive(object));
    }

    @Override
    public <T> List<T> getAsTypedList(Class<T> clazz) throws ClassCastException {
        return this.factory.getDriveService().getConversionHandler().createList(this, clazz, null);
    }

    @Override
    public List<DriveElement> getContents() {
        return (List)this.list.clone();
    }

    @Override
    public void addObject(DriveElement element) {
        this.list.add(element);
    }

    @Override
    public void addPrimitive(Object object) throws NotAPrimitiveTypeException {
        this.list.add(this.factory.createPrimitive(object));
    }

    @Override
    public Boolean getAsBoolean() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Short getAsShort() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Integer getAsInt() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Long getAsLong() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Character getAsChar() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public String getAsString() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Float getAsFloat() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Double getAsDouble() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public DriveObject getAsObject() throws ClassCastException {
        throw new ClassCastException("Drive Array is not an object");
    }

    @Override
    public DriveElement getAsElement() throws ClassCastException {
        return this;
    }

    @Override
    public DriveElementArray getAsElementArray() throws ClassCastException {
        return this;
    }

    @Override
    public Object getPrimitiveValue() {
        return null;
    }

    @Override
    public HashMap<String, DriveElement> getSubComponents() {
        return null;
    }

    public ArrayList<DriveElement> getList() {
        return this.list;
    }

    public DriveObjectFactory getFactory() {
        return this.factory;
    }

    public void setList(ArrayList<DriveElement> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleElementArray)) {
            return false;
        }
        SimpleElementArray other = (SimpleElementArray)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArrayList<DriveElement> this$list = this.getList();
        ArrayList<DriveElement> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        DriveObjectFactory this$factory = this.getFactory();
        DriveObjectFactory other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleElementArray;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayList<DriveElement> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        DriveObjectFactory $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleElementArray(list=" + this.getList() + ", factory=" + this.getFactory() + ")";
    }
}

