/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.endrealm.realmdrive.annotations.InjectParent;
import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.exceptions.ObjectReadOnlyException;
import net.endrealm.realmdrive.factory.DriveObjectFactory;
import net.endrealm.realmdrive.interfaces.ConversionHandler;
import net.endrealm.realmdrive.interfaces.CustomSerializer;
import net.endrealm.realmdrive.interfaces.DriveElement;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;
import net.endrealm.realmdrive.interfaces.DriveService;
import net.endrealm.realmdrive.utils.ReflectionUtils;
import net.endrealm.realmdrive.utils.properties.ClassProperties;
import net.endrealm.realmdrive.utils.properties.FieldProperties;
import net.endrealm.realmdrive.utils.properties.PropertyReader;

public class SimpleConversionHandler
implements ConversionHandler {
    private ArrayList<Class<?>> classes = new ArrayList();
    private ArrayList<CustomSerializer> serializers = new ArrayList();
    private DriveObjectFactory objectFactory;
    private DriveService driveService;
    private final Set<Class<?>> PRIMITIVE_CLASSES = ReflectionUtils.getPrimitiveWrapperTypes();

    @Override
    public void registerClasses(Class<?> ... classes) {
        this.classes.addAll(Arrays.asList(classes));
        for (Class<?> clazz : classes) {
            this.driveService.getBackend().prepareEntity(clazz);
        }
    }

    @Override
    public void registerSerializers(CustomSerializer ... serializers) {
        List<CustomSerializer> serializersList = Arrays.asList(serializers);
        Collections.reverse(serializersList);
        this.serializers.addAll(0, serializersList);
    }

    @Override
    public <T> T transform(DriveObject statisticsObject, Class<T> clazz) throws ClassCastException {
        return this.transform(statisticsObject, clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T transform(DriveObject statisticsObject, Class<T> clazz, Object parent) throws ClassCastException {
        if (statisticsObject == null || statisticsObject.isEmpty()) {
            return null;
        }
        Object object = this.getConvertedEndpoint(statisticsObject, clazz);
        if (object != null) {
            return (T)object;
        }
        DriveElement classElement = statisticsObject.get("className");
        if (classElement != null) {
            try {
                Class<?> storedClass = Class.forName(classElement.getAsString());
                if (clazz.isAssignableFrom(storedClass)) {
                    clazz = storedClass;
                }
            }
            catch (ClassNotFoundException storedClass) {
                // empty catch block
            }
        }
        if (!this.classes.contains(clazz)) {
            throw new ClassCastException(String.format("Failed to cast! %s is not registered!", clazz.getName()));
        }
        ClassProperties classProperties = PropertyReader.readProperties(clazz);
        try {
            Constructor<Object> constructor = null;
            if (clazz.getAnnotation(InjectParent.class) != null && parent != null) {
                Class<?> parentType = parent.getClass();
                while (constructor == null && parentType != null) {
                    try {
                        constructor = clazz.getConstructor(parentType);
                    }
                    catch (NoSuchMethodException | SecurityException exception) {}
                    continue;
                    finally {
                        parentType = parentType.getSuperclass();
                    }
                }
            }
            if (constructor == null) {
                constructor = clazz.getConstructor(new Class[0]);
            }
            Object instance = constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(parent);
            for (Field field : ReflectionUtils.getAllFields(clazz)) {
                FieldProperties fieldProperties = PropertyReader.readProperties(field, classProperties);
                if (!fieldProperties.isRead()) continue;
                boolean protection = field.isAccessible();
                field.setAccessible(true);
                DriveElement value = statisticsObject.get(fieldProperties.getName());
                for (int i = 0; value == null && i < fieldProperties.getAliases().size(); ++i) {
                    value = statisticsObject.get(fieldProperties.getAliases().get(i));
                }
                if (value == null) {
                    if (fieldProperties.isOptional()) continue;
                    throw new ClassCastException(String.format("Found unmapped field %s in %s!", field.getName(), field.getDeclaringClass().getName()));
                }
                Object object2 = this.getConvertedEndpoint(value, field.getType());
                if (object2 != null) {
                    field.set(instance, object2);
                    continue;
                }
                if (value instanceof DriveElementArray) {
                    DriveElementArray array = value.getAsElementArray();
                    if (array.getContents().isEmpty()) {
                        field.set(instance, new ArrayList());
                        continue;
                    }
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    Class listGenericClass = (Class)listType.getActualTypeArguments()[0];
                    List list = this.createList(array, listGenericClass, instance);
                    field.set(instance, list);
                } else if (value.getPrimitiveValue() == null) {
                    field.set(instance, this.transform(value.getAsObject(), field.getType(), instance));
                } else {
                    Object primitiveValue = value.getPrimitiveValue();
                    if ((field.getType() == Float.TYPE || field.getType() == Float.class) && primitiveValue.getClass() == Double.class) {
                        field.set(instance, Float.valueOf((float)((Double)primitiveValue).doubleValue()));
                    } else {
                        field.set(instance, primitiveValue);
                    }
                }
                field.setAccessible(protection);
            }
            return (T)instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassCastException(String.format("Failed to cast! Maybe %s does not have an empty public constructor!", clazz.getName()));
        }
    }

    private Object getConvertedEndpoint(DriveElement element, Class clazz) {
        for (CustomSerializer serializer : this.serializers) {
            if (!serializer.supportsClass(clazz)) continue;
            return serializer.fromEndpoint(element, clazz);
        }
        return null;
    }

    private DriveElement getElementEndpoint(Object element, Class clazz) {
        for (CustomSerializer serializer : this.serializers) {
            if (!serializer.supportsClass(clazz)) continue;
            return serializer.toDriveEndpoint(element);
        }
        return null;
    }

    @Override
    public List createList(DriveElementArray array, Class clazz, Object parent) throws ClassCastException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.PRIMITIVE_CLASSES.contains(clazz)) {
            for (DriveElement driveElement : array.getContents()) {
                list.add(driveElement.getPrimitiveValue());
            }
        } else {
            if (DriveElementArray.class.isAssignableFrom(clazz)) {
                throw new ClassCastException("List stacking is not supported");
            }
            for (DriveElement driveElement : array.getContents()) {
                list.add(this.transform(driveElement.getAsObject(), clazz, parent));
            }
        }
        return list;
    }

    @Override
    public DriveObject transform(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!this.classes.contains(clazz)) {
            throw new ClassCastException(String.format("Failed to cast! %s is not registered!", clazz.getName()));
        }
        List<Field> fieldList = ReflectionUtils.getAllFields(clazz);
        ClassProperties classProperties = PropertyReader.readProperties(clazz);
        DriveObject statisticsObject = this.objectFactory.createEmptyObject();
        try {
            statisticsObject.setPrimitive("className", object.getClass().getName());
            for (Field field : fieldList) {
                FieldProperties fieldProperties = PropertyReader.readProperties(field, classProperties);
                if (!fieldProperties.isWrite()) continue;
                boolean protection = field.isAccessible();
                field.setAccessible(true);
                Object value = field.get(object);
                if (value == null) {
                    if (fieldProperties.isOptional()) continue;
                    throw new ClassCastException(String.format("Found empty non optional field %s in %s!", field.getName(), field.getDeclaringClass().getName()));
                }
                DriveElement driveElement = this.getElementEndpoint(value, value.getClass());
                if (driveElement != null) {
                    statisticsObject.setObject(fieldProperties.getName(), driveElement);
                } else if (this.PRIMITIVE_CLASSES.contains(value.getClass())) {
                    statisticsObject.setObject(fieldProperties.getName(), this.objectFactory.createPrimitive(value));
                } else if (List.class.isAssignableFrom(field.getType())) {
                    DriveElementArray array = this.objectFactory.createEmptyArray();
                    for (Object obj : (List)value) {
                        if (this.PRIMITIVE_CLASSES.contains(obj.getClass())) {
                            array.addObject(this.objectFactory.createPrimitive(obj));
                            continue;
                        }
                        array.addObject(this.transform(obj));
                    }
                    statisticsObject.setObject(fieldProperties.getName(), array);
                } else {
                    statisticsObject.setObject(fieldProperties.getName(), this.transform(value));
                }
                field.setAccessible(protection);
            }
        }
        catch (IllegalAccessException | NotAPrimitiveTypeException | ObjectReadOnlyException e) {
            e.printStackTrace();
            throw new ClassCastException();
        }
        return statisticsObject;
    }

    @Deprecated
    public String stringify(DriveElement element) {
        if (element == null) {
            return "{}";
        }
        if (element instanceof DriveElementArray) {
            String json = "[";
            for (DriveElement elem : element.getAsElementArray().getContents()) {
                json = json + this.stringify(elem) + ",";
            }
            json = json.substring(0, json.length() - 1);
            json = json + "]";
            return json;
        }
        if (!(element instanceof DriveObject)) {
            Object value = element.getPrimitiveValue();
            if (value instanceof String || value instanceof Character) {
                return "\"" + value + "\"";
            }
            return "" + value;
        }
        String json = "{";
        for (Map.Entry<String, DriveElement> entry : element.getSubComponents().entrySet()) {
            json = json + "\"" + entry.getKey() + "\":" + this.stringify(entry.getValue()) + ",";
        }
        json = json.substring(0, json.length() - 1);
        json = json + "}";
        return json;
    }

    @Override
    public Object transformAutomatically(DriveObject statisticsObject) {
        DriveElement element = statisticsObject.get("className");
        if (element == null) {
            return null;
        }
        for (Class<?> clazz : this.classes) {
            if (!clazz.getName().equals(element.getPrimitiveValue())) continue;
            return this.transform(statisticsObject, clazz);
        }
        return null;
    }

    @Override
    public void setService(DriveService service) {
        this.objectFactory = new DriveObjectFactory(service);
        this.driveService = service;
    }

    public ArrayList<Class<?>> getClasses() {
        return this.classes;
    }

    public ArrayList<CustomSerializer> getSerializers() {
        return this.serializers;
    }

    public DriveObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public DriveService getDriveService() {
        return this.driveService;
    }

    public Set<Class<?>> getPRIMITIVE_CLASSES() {
        return this.PRIMITIVE_CLASSES;
    }

    public void setClasses(ArrayList<Class<?>> classes) {
        this.classes = classes;
    }

    public void setSerializers(ArrayList<CustomSerializer> serializers) {
        this.serializers = serializers;
    }

    public void setObjectFactory(DriveObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setDriveService(DriveService driveService) {
        this.driveService = driveService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleConversionHandler)) {
            return false;
        }
        SimpleConversionHandler other = (SimpleConversionHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArrayList<Class<?>> this$classes = this.getClasses();
        ArrayList<Class<?>> other$classes = other.getClasses();
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        ArrayList<CustomSerializer> this$serializers = this.getSerializers();
        ArrayList<CustomSerializer> other$serializers = other.getSerializers();
        if (this$serializers == null ? other$serializers != null : !((Object)this$serializers).equals(other$serializers)) {
            return false;
        }
        DriveObjectFactory this$objectFactory = this.getObjectFactory();
        DriveObjectFactory other$objectFactory = other.getObjectFactory();
        if (this$objectFactory == null ? other$objectFactory != null : !this$objectFactory.equals(other$objectFactory)) {
            return false;
        }
        DriveService this$driveService = this.getDriveService();
        DriveService other$driveService = other.getDriveService();
        if (this$driveService == null ? other$driveService != null : !this$driveService.equals(other$driveService)) {
            return false;
        }
        Set<Class<?>> this$PRIMITIVE_CLASSES = this.getPRIMITIVE_CLASSES();
        Set<Class<?>> other$PRIMITIVE_CLASSES = other.getPRIMITIVE_CLASSES();
        return !(this$PRIMITIVE_CLASSES == null ? other$PRIMITIVE_CLASSES != null : !((Object)this$PRIMITIVE_CLASSES).equals(other$PRIMITIVE_CLASSES));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleConversionHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayList<Class<?>> $classes = this.getClasses();
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        ArrayList<CustomSerializer> $serializers = this.getSerializers();
        result = result * 59 + ($serializers == null ? 43 : ((Object)$serializers).hashCode());
        DriveObjectFactory $objectFactory = this.getObjectFactory();
        result = result * 59 + ($objectFactory == null ? 43 : $objectFactory.hashCode());
        DriveService $driveService = this.getDriveService();
        result = result * 59 + ($driveService == null ? 43 : $driveService.hashCode());
        Set<Class<?>> $PRIMITIVE_CLASSES = this.getPRIMITIVE_CLASSES();
        result = result * 59 + ($PRIMITIVE_CLASSES == null ? 43 : ((Object)$PRIMITIVE_CLASSES).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleConversionHandler(classes=" + this.getClasses() + ", serializers=" + this.getSerializers() + ", objectFactory=" + this.getObjectFactory() + ", driveService=" + this.getDriveService() + ", PRIMITIVE_CLASSES=" + this.getPRIMITIVE_CLASSES() + ")";
    }
}

