/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectionUtils {
    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            ReflectionUtils.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static List<Field> getAllFields(Class<?> type) {
        return ReflectionUtils.getAllFields(new ArrayList<Field>(), type);
    }

    public static List<Field> getAllAnnotatedFields(Class<?> type, Class ... annotations) {
        ArrayList<Field> rawFields = new ArrayList<Field>();
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        ReflectionUtils.getAllFields(rawFields, type);
        for (Field field : rawFields) {
            if (!ReflectionUtils.hasAnnotation(field, annotations)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    private static boolean hasAnnotation(Field field, Class[] annotations) {
        for (Class clazz : annotations) {
            if (field.getAnnotation(clazz) == null) continue;
            return true;
        }
        return false;
    }

    public static Set<Class<?>> getPrimitiveWrapperTypes() {
        HashSet prims = new HashSet();
        prims.add(Character.class);
        prims.add(String.class);
        prims.add(Boolean.class);
        prims.add(Byte.class);
        prims.add(Short.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Float.class);
        prims.add(Double.class);
        return prims;
    }
}

