/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.utils;

import java.util.ArrayList;
import java.util.Map;
import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.exceptions.ObjectReadOnlyException;
import net.endrealm.realmdrive.factory.DriveObjectFactory;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;
import org.bson.Document;
import org.bson.types.ObjectId;

public class BsonUtils {
    public static DriveObject unStringify(Document jsonObject, DriveObjectFactory objectFactory) {
        DriveObject statisticsObject = objectFactory.createEmptyObject();
        try {
            for (Map.Entry entry : jsonObject.entrySet()) {
                Object element = entry.getValue();
                if (element instanceof ObjectId) continue;
                if (element instanceof Document) {
                    try {
                        statisticsObject.setObject((String)entry.getKey(), BsonUtils.unStringify((Document)element, objectFactory));
                    }
                    catch (ObjectReadOnlyException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (element instanceof ArrayList) {
                    ArrayList basicBSONList = (ArrayList)element;
                    DriveElementArray array = objectFactory.createEmptyArray();
                    for (Object obj : basicBSONList) {
                        if (obj instanceof ObjectId) continue;
                        if (obj instanceof Document) {
                            array.addObject(BsonUtils.unStringify((Document)obj, objectFactory));
                            continue;
                        }
                        array.addPrimitive(obj);
                    }
                    statisticsObject.setObject((String)entry.getKey(), array);
                    continue;
                }
                statisticsObject.setPrimitive((String)entry.getKey(), element);
            }
        }
        catch (NotAPrimitiveTypeException | ObjectReadOnlyException e) {
            e.printStackTrace();
        }
        return statisticsObject;
    }
}

