/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.query.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.endrealm.realmdrive.query.QueryComponent;
import net.endrealm.realmdrive.query.compare.CompareOperator;
import net.endrealm.realmdrive.utils.JsonUtils;

public class ValueBetweenOperator<T extends QueryComponent>
extends CompareOperator<T> {
    private int start;
    private int end;
    private boolean startInclusive = true;
    private boolean endInclusive = false;
    private String field = "";

    public ValueBetweenOperator(T parent) {
        super(parent);
    }

    public ValueBetweenOperator<T> setStart(int startVal) {
        this.start = startVal;
        return this;
    }

    public ValueBetweenOperator<T> setField(String field) {
        this.field = field;
        return this;
    }

    public ValueBetweenOperator<T> setStartInclusive(boolean startInclusive) {
        this.startInclusive = startInclusive;
        return this;
    }

    @Override
    public String toJson() {
        return String.format("{\"%s\": { $in: [%s] }}", this.field, this.getAllVals().stream().map(JsonUtils::parsePrimitive).collect(Collectors.joining(",")));
    }

    private List<Integer> getAllVals() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = this.startInclusive ? this.start : this.start + 1; i < (this.endInclusive ? this.end : this.end - 1); ++i) {
            values.add(i);
        }
        return values;
    }
}

