/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import net.endrealm.realmdrive.interfaces.DriveObject;
import net.endrealm.realmdrive.interfaces.DriveService;
import net.endrealm.realmdrive.interfaces.DriveWriter;
import net.endrealm.realmdrive.query.Query;
import net.endrealm.realmdrive.utils.ThreadUtils;
import net.endrealm.realmdrive.utils.properties.ClassProperties;
import net.endrealm.realmdrive.utils.properties.PropertyReader;

public class SimpleDriveWriter
implements DriveWriter {
    private DriveService driveService;

    @Override
    public void write(DriveObject element) {
        this.write(element, new Query().build());
    }

    @Override
    public void writeAsync(DriveObject element, Runnable onFinish) {
        this.writeAsync(element, new Query().build(), onFinish);
    }

    @Override
    public void write(Object object) {
        Query query = new Query().build();
        this.applyQueryChanges(object, query);
        this.write(object, query);
    }

    @Override
    public void writeAsync(Object object, Runnable onFinish) {
        Query query = new Query().build();
        this.applyQueryChanges(object, query);
        this.writeAsync(object, query, onFinish);
    }

    @Override
    public void write(DriveObject element, Query query) {
        this.driveService.getBackend().write(element, query);
    }

    @Override
    public void writeAsync(DriveObject element, Query query, Runnable onFinish) {
        ThreadUtils.createNewThread(() -> {
            this.write(element, query);
            onFinish.run();
        });
    }

    @Override
    public void write(Object object, Query query) {
        this.applyQueryChanges(object, query);
        this.write(this.driveService.getConversionHandler().transform(object), query);
    }

    @Override
    public void writeAsync(Object object, Query query, Runnable onFinish) {
        ThreadUtils.createNewThread(() -> {
            this.applyQueryChanges(object, query);
            this.write(object, query);
            onFinish.run();
        });
    }

    @Override
    public void write(DriveObject element, boolean overwrite, Query queryDetails) {
        this.driveService.getBackend().writeReplace(element, queryDetails);
    }

    @Override
    public void writeAsync(DriveObject element, boolean overwrite, Query queryDetails, Runnable onFinish) {
        ThreadUtils.createNewThread(() -> {
            this.write(element, overwrite, queryDetails);
            onFinish.run();
        });
    }

    @Override
    public void write(Object object, boolean overwrite, Query queryDetails) {
        this.applyQueryChanges(object, queryDetails);
        this.write(this.driveService.getConversionHandler().transform(object), overwrite, queryDetails);
    }

    @Override
    public void writeAsync(Object object, boolean overwrite, Query queryDetails, Runnable onFinish) {
        ThreadUtils.createNewThread(() -> {
            this.applyQueryChanges(object, queryDetails);
            this.write(object, overwrite, queryDetails);
            onFinish.run();
        });
    }

    @Override
    public void replace(DriveObject element, Query queryDetails) {
        this.driveService.getBackend().replace(element, queryDetails);
    }

    @Override
    public void replaceAsync(DriveObject element, Query queryDetails, Runnable onFinish) {
        ThreadUtils.createNewThread(() -> {
            this.replace(element, queryDetails);
            onFinish.run();
        });
    }

    @Override
    public void replace(Object object, Query queryDetails) {
        this.applyQueryChanges(object, queryDetails);
        this.replace(this.driveService.getConversionHandler().transform(object), queryDetails);
    }

    @Override
    public void replaceAsync(Object object, Query queryDetails, Runnable onFinish) {
        this.replaceAsync(this.driveService.getConversionHandler().transform(object), queryDetails, onFinish);
    }

    @Override
    public void delete(Query queryDetails, int amount) {
        if (amount < 0) {
            this.driveService.getBackend().deleteAll(queryDetails);
        } else if (amount > 0) {
            for (int i = 0; i < amount; ++i) {
                this.driveService.getBackend().delete(queryDetails);
            }
        }
    }

    @Override
    public void deleteAsync(Query queryDetails, int amount, Runnable onFinish) {
        ThreadUtils.createNewThread(() -> {
            this.delete(queryDetails, amount);
            onFinish.run();
        });
    }

    @Override
    public void setService(DriveService service) {
        this.driveService = service;
    }

    private void applyQueryChanges(Object object, Query query) {
        ClassProperties classProperties = PropertyReader.readProperties(object.getClass());
        if (classProperties.getTableName() != null) {
            query.setTableName(classProperties.getTableName());
        }
    }
}

