/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.endrealm.realmdrive.interfaces.DriveObject;
import net.endrealm.realmdrive.interfaces.DriveReader;
import net.endrealm.realmdrive.interfaces.DriveService;
import net.endrealm.realmdrive.query.Query;
import net.endrealm.realmdrive.utils.ThreadUtils;

public class SimpleDriveReader
implements DriveReader {
    private DriveService driveService;

    @Override
    public boolean containsObject(Query query) {
        return this.readObject(query) != null;
    }

    @Override
    public void containsObjectAsync(Query query, Consumer<Boolean> onResult) {
        ThreadUtils.createNewThread(() -> onResult.accept(this.containsObject(query)));
    }

    @Override
    public DriveObject readObject(Query query) {
        return this.driveService.getBackend().findOne(query);
    }

    @Override
    public void readObjectAsync(Query query, Consumer<DriveObject> onSuccess, Runnable onFailure) {
        ThreadUtils.createNewThread(() -> {
            DriveObject result = this.readObject(query);
            if (result != null) {
                onSuccess.accept(result);
            } else {
                onFailure.run();
            }
        });
    }

    @Override
    public <T> T readObject(Query query, Class<T> clazz) throws ClassCastException {
        return this.driveService.getConversionHandler().transform(this.readObject(query), clazz);
    }

    @Override
    public <T> void readObjectAsync(Query query, Class<T> clazz, Consumer<T> onSuccess, Runnable onFailure, Consumer<Throwable> onError) {
        ThreadUtils.createNewThread(() -> {
            try {
                Object result = this.readObject(query, clazz);
                if (result != null) {
                    onSuccess.accept(result);
                } else {
                    onFailure.run();
                }
            }
            catch (Exception ex) {
                onError.accept(ex);
            }
        });
    }

    @Override
    public List<DriveObject> readAllObjects(Query query) {
        return this.driveService.getBackend().findAll(query);
    }

    @Override
    public void readAllObjectsAsync(Query query, Consumer<List<DriveObject>> onResult) {
        ThreadUtils.createNewThread(() -> {
            List<DriveObject> result = this.readAllObjects(query);
            onResult.accept(result);
        });
    }

    @Override
    public <T> List<T> readAllObjects(Query query, Class<T> clazz) throws ClassCastException {
        ArrayList<T> list = new ArrayList<T>();
        for (DriveObject obj : this.readAllObjects(query)) {
            list.add(this.driveService.getConversionHandler().transform(obj, clazz));
        }
        return list;
    }

    @Override
    public <T> void readAllObjects(Query query, Class<T> clazz, Consumer<List<T>> onSuccess, Consumer<Throwable> onError) {
        ThreadUtils.createNewThread(() -> {
            try {
                List result = this.readAllObjects(query, clazz);
                onSuccess.accept(result);
            }
            catch (Exception ex) {
                onError.accept(ex);
            }
        });
    }

    @Override
    public void setService(DriveService service) {
        this.driveService = service;
    }
}

