/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import java.util.HashMap;
import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.factory.DriveObjectFactory;
import net.endrealm.realmdrive.interfaces.DriveElement;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;

public class SimpleDriveObject
implements DriveObject {
    private HashMap<String, DriveElement> elementHashMap;
    private final DriveObjectFactory factory;

    public SimpleDriveObject(DriveObjectFactory factory) {
        this.factory = factory;
        this.elementHashMap = new HashMap();
    }

    @Override
    public DriveElement get(String key) {
        return this.elementHashMap.get(key);
    }

    @Override
    public DriveObject getAsObject(String key) {
        return (DriveObject)this.elementHashMap.get(key);
    }

    @Override
    public void setObject(String key, DriveElement element) {
        this.elementHashMap.put(key, element);
    }

    @Override
    public void setPrimitive(String key, Object object) {
        try {
            this.elementHashMap.put(key, this.factory.createPrimitive(object));
        }
        catch (NotAPrimitiveTypeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T> T getAsTypedObject(Class<T> clazz) throws ClassCastException {
        return this.factory.getDriveService().getConversionHandler().transform(this, clazz);
    }

    @Override
    public boolean isEmpty() {
        return this.elementHashMap.isEmpty();
    }

    @Override
    public Boolean getAsBoolean() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Short getAsShort() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Integer getAsInt() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Long getAsLong() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Character getAsChar() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public String getAsString() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Float getAsFloat() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public Double getAsDouble() throws ClassCastException, NotAPrimitiveTypeException {
        throw new NotAPrimitiveTypeException();
    }

    @Override
    public DriveObject getAsObject() throws ClassCastException {
        return this;
    }

    @Override
    public DriveElement getAsElement() throws ClassCastException {
        return this;
    }

    @Override
    public DriveElementArray getAsElementArray() throws ClassCastException {
        throw new ClassCastException("This is a statistics object not an array");
    }

    @Override
    public Object getPrimitiveValue() {
        return null;
    }

    @Override
    public HashMap<String, DriveElement> getSubComponents() {
        return this.elementHashMap;
    }

    public HashMap<String, DriveElement> getElementHashMap() {
        return this.elementHashMap;
    }

    public DriveObjectFactory getFactory() {
        return this.factory;
    }

    public void setElementHashMap(HashMap<String, DriveElement> elementHashMap) {
        this.elementHashMap = elementHashMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleDriveObject)) {
            return false;
        }
        SimpleDriveObject other = (SimpleDriveObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashMap<String, DriveElement> this$elementHashMap = this.getElementHashMap();
        HashMap<String, DriveElement> other$elementHashMap = other.getElementHashMap();
        if (this$elementHashMap == null ? other$elementHashMap != null : !((Object)this$elementHashMap).equals(other$elementHashMap)) {
            return false;
        }
        DriveObjectFactory this$factory = this.getFactory();
        DriveObjectFactory other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleDriveObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashMap<String, DriveElement> $elementHashMap = this.getElementHashMap();
        result = result * 59 + ($elementHashMap == null ? 43 : ((Object)$elementHashMap).hashCode());
        DriveObjectFactory $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleDriveObject(elementHashMap=" + this.getElementHashMap() + ", factory=" + this.getFactory() + ")";
    }
}

