/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.endrealm.realmdrive.factory.DriveObjectFactory;
import net.endrealm.realmdrive.interfaces.DriveBackend;
import net.endrealm.realmdrive.interfaces.DriveElement;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;
import net.endrealm.realmdrive.interfaces.DriveService;
import net.endrealm.realmdrive.query.Query;
import net.endrealm.realmdrive.utils.BsonUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.BasicBSONList;

public class MongoBackend
implements DriveBackend {
    private MongoClient mongoClient;
    private DriveService driveService;
    private MongoDatabase database;
    private MongoCollection collection;

    @Override
    public void connect(String hostURL, String username, String password, String database, String table) {
        assert (hostURL != null);
        this.mongoClient = new MongoClient(new MongoClientURI(hostURL, MongoClientOptions.builder().heartbeatFrequency(1000)));
        assert (database != null);
        this.database = this.mongoClient.getDatabase(database);
        assert (table != null);
        this.collection = this.database.getCollection(table);
    }

    @Override
    public void setService(DriveService service) {
        this.driveService = service;
    }

    @Override
    public void write(DriveObject driveObject, Query query) {
        this.readCollectionFromQuery(query).insertOne((Object)this.toMongoDocument(driveObject));
    }

    public Iterable sendRawQuery(Bson query) {
        return this.collection.find(query);
    }

    @Override
    @Deprecated
    public Iterable rawQuery(Object query) {
        if (!(query instanceof QueryBuilder)) {
            return null;
        }
        return null;
    }

    @Override
    public void prepareEntity(Class<?> clazz) {
    }

    @Override
    public DriveObject findOne(Query queryDetails) {
        Document query = this.readQuery(queryDetails);
        MongoCollection collection = this.readCollectionFromQuery(queryDetails);
        FindIterable iterable = collection.find((Bson)query);
        Document result = (Document)iterable.first();
        if (result == null) {
            return null;
        }
        return BsonUtils.unStringify(result, new DriveObjectFactory(this.driveService));
    }

    private MongoCollection readCollectionFromQuery(Query queryDetails) {
        MongoDatabase database = queryDetails.getDatabaseName() == null ? this.database : this.mongoClient.getDatabase(queryDetails.getDatabaseName());
        return queryDetails.getTableName() == null ? this.collection : database.getCollection(queryDetails.getTableName());
    }

    @Override
    public List<DriveObject> findAll(Query queryDetails) {
        Document query = this.readQuery(queryDetails);
        FindIterable iterable = this.readCollectionFromQuery(queryDetails).find((Bson)query);
        ArrayList<DriveObject> result = new ArrayList<DriveObject>();
        for (Object item : iterable) {
            Document document = (Document)item;
            result.add(BsonUtils.unStringify(document, new DriveObjectFactory(this.driveService)));
        }
        return result;
    }

    private Document readQuery(Query query) {
        BasicDBObject dbObject = BasicDBObject.parse((String)query.toJson());
        return new Document(dbObject.toMap());
    }

    private Document toMongoDocument(DriveObject statisticsObject) {
        Document dbObject = new Document();
        for (Map.Entry<String, DriveElement> entry : statisticsObject.getSubComponents().entrySet()) {
            DriveElement element = entry.getValue();
            if (element.getPrimitiveValue() != null) {
                dbObject.append(entry.getKey(), element.getPrimitiveValue());
                continue;
            }
            if (element instanceof DriveObject) {
                dbObject.append(entry.getKey(), (Object)this.toMongoDocument(element.getAsObject()));
                continue;
            }
            dbObject.append(entry.getKey(), (Object)this.toMongoList(element.getAsElementArray()));
        }
        return dbObject;
    }

    private BasicBSONList toMongoList(DriveElementArray array) {
        BasicBSONList basicBSONList = new BasicBSONList();
        for (DriveElement element : array.getContents()) {
            if (element.getPrimitiveValue() != null) {
                basicBSONList.add(element.getPrimitiveValue());
                continue;
            }
            if (element instanceof DriveObject) {
                basicBSONList.add((Object)this.toMongoDocument(element.getAsObject()));
                continue;
            }
            basicBSONList.add((Object)this.toMongoList(element.getAsElementArray()));
        }
        return basicBSONList;
    }

    @Override
    public void writeReplace(DriveObject element, Query queryDetails) {
        this.delete(queryDetails);
        this.write(element, queryDetails);
    }

    @Override
    public void replace(DriveObject element, Query query) {
        this.readCollectionFromQuery(query).replaceOne((Bson)this.readQuery(query), (Object)this.toMongoDocument(element));
    }

    @Override
    public void deleteAll(Query queryDetails) {
        this.readCollectionFromQuery(queryDetails).deleteMany((Bson)this.readQuery(queryDetails));
    }

    @Override
    public void delete(Query queryDetails) {
        this.readCollectionFromQuery(queryDetails).deleteOne((Bson)this.readQuery(queryDetails));
    }
}

