/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.factory;

import net.endrealm.realmdrive.inst.MongoBackend;
import net.endrealm.realmdrive.inst.SimpleConversionHandler;
import net.endrealm.realmdrive.inst.SimpleDriveReader;
import net.endrealm.realmdrive.inst.SimpleDriveService;
import net.endrealm.realmdrive.inst.SimpleDriveWriter;
import net.endrealm.realmdrive.inst.serializers.DateSerializer;
import net.endrealm.realmdrive.inst.serializers.EnumSerializer;
import net.endrealm.realmdrive.inst.serializers.UUIDSerializer;
import net.endrealm.realmdrive.interfaces.DriveBackend;
import net.endrealm.realmdrive.interfaces.DriveService;
import net.endrealm.realmdrive.utils.DriveSettings;

public class DriveServiceFactory {
    public DriveService getDriveService(DriveSettings settings) {
        assert (settings.getType() != null);
        DriveBackend backend = this.getDriveBackend(settings.getType());
        SimpleDriveWriter writer = new SimpleDriveWriter();
        SimpleDriveReader reader = new SimpleDriveReader();
        SimpleConversionHandler conversion = new SimpleConversionHandler();
        conversion.registerSerializers(new UUIDSerializer(), new DateSerializer(), new EnumSerializer());
        SimpleDriveService driveService = new SimpleDriveService(backend, reader, writer, conversion);
        backend.connect(settings.getHostURL(), settings.getUsername(), settings.getPassword(), settings.getDatabase(), settings.getTable());
        backend.setService(driveService);
        writer.setService(driveService);
        reader.setService(driveService);
        conversion.setService(driveService);
        return driveService;
    }

    private DriveBackend getDriveBackend(DriveSettings.BackendType type) {
        switch (type) {
            case MONGO_DB: {
                return new MongoBackend();
            }
        }
        return new MongoBackend();
    }
}

