/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.freemarker;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.emphased.malle.AddressType;
import net.emphased.malle.BodyType;
import net.emphased.malle.Encoding;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.Mail;
import net.emphased.malle.support.InputStreamSuppliers;
import net.emphased.malle.template.freemarker.ObjectModel;

class MailDirective
implements TemplateDirectiveModel {
    public static final String NAME = "mail";
    private static final Map<String, Handler> CMD_HANDLERS;
    private static final Map<String, Encoding> STR_TO_ENCODING;

    MailDirective() {
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, @Nullable TemplateDirectiveBody body) throws TemplateException, IOException {
        this.doExecute(env, params, loopVars, body);
    }

    private void doExecute(Environment env, Map<String, Object> params, TemplateModel[] loopVars, @Nullable TemplateDirectiveBody body) throws TemplateException, IOException {
        String bodyStr;
        if (loopVars.length != 0) {
            throw new TemplateModelException("'mail' directive doesn't allow loop variables");
        }
        String cmd = MailDirective.getStringParam(params = new HashMap<String, Object>(params), "cmd");
        Handler handler = CMD_HANDLERS.get(cmd);
        if (handler == null) {
            throw new TemplateModelException("Unknown command passed to 'mail' directive: " + cmd);
        }
        String string = bodyStr = body != null ? this.renderBody(body) : null;
        TrimMode defaultTrimMode = handler instanceof BodyHandler && ((BodyHandler)handler).getType() == BodyType.PLAIN ? TrimMode.trailing : (handler instanceof AttachmentHandler ? TrimMode.none : TrimMode.both);
        TrimMode trimMode = MailDirective.getEnumParam(params, "trim", TrimMode.class, defaultTrimMode);
        if (bodyStr != null) {
            bodyStr = this.trim(bodyStr, trimMode);
        }
        Mail m = this.getMessage(env);
        handler.handle(cmd, m, bodyStr, params);
        if (!params.isEmpty()) {
            throw new TemplateModelException("Unknown parameters passed to 'mail' (cmd = '" + cmd + "') directive: " + params.keySet());
        }
    }

    private String trim(String value, TrimMode mode) {
        switch (mode) {
            case none: {
                return this.trimFirstLineEndings(value, TrimMode.trailing);
            }
            case both: {
                return value.trim();
            }
            case leading: {
                return this.trimFirstLineEndings(value.replaceFirst("^\\s+", ""), TrimMode.trailing);
            }
            case trailing: {
                return value.replaceFirst("\\s+$", "");
            }
        }
        throw new AssertionError((Object)("Unhandled mode: " + (Object)((Object)mode)));
    }

    private String trimFirstLineEndings(String s, TrimMode mode) {
        int i;
        if (mode == TrimMode.both || mode == TrimMode.leading) {
            i = 0;
            if (s.startsWith("\r\n")) {
                i += 2;
            } else if (s.startsWith("\r") || s.startsWith("\n")) {
                ++i;
            }
            s = s.substring(i);
        }
        if (mode == TrimMode.both || mode == TrimMode.trailing) {
            i = s.length();
            if (s.endsWith("\r\n")) {
                i -= 2;
            } else if (s.endsWith("\r") || s.endsWith("\n")) {
                --i;
            }
            s = s.substring(0, i);
        }
        return s;
    }

    private static String getStringParam(Map<String, ?> params, String name, @Nullable String defaultValue) throws TemplateModelException {
        Object o = params.remove(name);
        if (o == null) {
            return defaultValue;
        }
        if (!(o instanceof SimpleScalar)) {
            throw new TemplateModelException("'mail' directive requires '" + name + "' parameter to be a string");
        }
        return ((SimpleScalar)o).getAsString();
    }

    private static String getStringParam(Map<String, ?> params, String name) throws TemplateModelException {
        return MailDirective.checkParamPresent(MailDirective.getStringParam(params, name, null), name);
    }

    private static Integer getIntParam(Map<String, ?> params, String name, @Nullable Integer defaultValue) throws TemplateModelException {
        String s = MailDirective.getStringParam(params, name, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new TemplateModelException("'mail' directive requires '" + name + "' parameter to be a valid integer", (Exception)e);
        }
    }

    private static int getIntParam(Map<String, ?> params, String name) throws TemplateModelException {
        return MailDirective.checkParamPresent(MailDirective.getIntParam(params, name, null), name);
    }

    private static <T extends Enum<T>> T getEnumParam(Map<String, ?> params, String name, Class<T> type, @Nullable T defaultValue) throws TemplateModelException {
        String s = MailDirective.getStringParam(params, name, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, s);
        }
        catch (IllegalArgumentException e) {
            throw new TemplateModelException("'mail' directive requires '" + name + "' parameter to be one of: " + Arrays.toString(type.getEnumConstants()), (Exception)e);
        }
    }

    private static <T extends Enum<T>> T getEnumParam(Map<String, ?> params, String name, Class<T> type) throws TemplateModelException {
        return (T)((Enum)MailDirective.checkParamPresent(MailDirective.getEnumParam(params, name, type, null), name));
    }

    private static <T> T checkParamPresent(T value, String name) throws TemplateModelException {
        if (value == null) {
            throw new TemplateModelException("'mail' directive requires '" + name + "' parameter to be present");
        }
        return value;
    }

    private static Encoding getEncodingParam(Map<String, ?> params, String name, @Nullable Encoding defaultValue) throws TemplateModelException {
        String s = MailDirective.getStringParam(params, name, null);
        if (s == null) {
            return defaultValue;
        }
        Encoding r = STR_TO_ENCODING.get(s);
        if (r == null) {
            throw new TemplateModelException("'mail' directive requires '" + name + "' parameter to be one of: " + STR_TO_ENCODING.keySet());
        }
        return r;
    }

    private static Charset getCharsetParam(Map<String, ?> params, String name) throws TemplateModelException {
        return MailDirective.checkParamPresent(MailDirective.getCharsetParam(params, name, null), name);
    }

    private static Charset getCharsetParam(Map<String, ?> params, String name, @Nullable Charset defaultValue) throws TemplateModelException {
        String s = MailDirective.getStringParam(params, name, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Charset.forName(s);
        }
        catch (UnsupportedCharsetException e) {
            throw new TemplateModelException("'mail' directive requires '" + name + "' parameter to be a valid charset");
        }
    }

    private static Encoding getEncodingParam(Map<String, ?> params, String name) throws TemplateModelException {
        return MailDirective.checkParamPresent(MailDirective.getEncodingParam(params, name, null), name);
    }

    private Mail getMessage(Environment env) throws TemplateModelException {
        return (Mail)((ObjectModel)env.getDataModel().get("__malle_mail")).getObject();
    }

    private String renderBody(TemplateDirectiveBody body) throws IOException, TemplateException {
        StringWriter content = new StringWriter();
        body.render((Writer)content);
        return content.toString();
    }

    static {
        HashMap<String, Handler> m = new HashMap<String, Handler>();
        m.put("from", new AddressHandler(AddressType.FROM));
        m.put("to", new AddressHandler(AddressType.TO));
        m.put("cc", new AddressHandler(AddressType.CC));
        m.put("bcc", new AddressHandler(AddressType.BCC));
        m.put("priority", new PriorityHandler());
        m.put("subject", new SubjectHandler());
        m.put("plain", new BodyHandler(BodyType.PLAIN));
        m.put("html", new BodyHandler(BodyType.HTML));
        m.put("attachment", new AttachmentHandler(false));
        m.put("inline", new AttachmentHandler(true));
        m.put("settings", new SettingsHandler());
        CMD_HANDLERS = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("base64", (Handler)Encoding.BASE64);
        m.put("quoted-printable", (Handler)Encoding.QUOTED_PRINTABLE);
        m.put("8bit", (Handler)Encoding.EIGHT_BIT);
        m.put("7bit", (Handler)Encoding.SEVEN_BIT);
        m.put("binary", (Handler)Encoding.BINARY);
        if (Encoding.values().length != m.size()) {
            throw new AssertionError((Object)"Not all Encoding values have mappings in STR_TO_ENCODING");
        }
        m.put("auto", null);
        STR_TO_ENCODING = Collections.unmodifiableMap(m);
    }

    private static class AttachmentHandler
    implements Handler {
        private static final Map<String, ISSFactory> ISS_FACTORIES;
        private final boolean inline;

        public AttachmentHandler(boolean inline) {
            this.inline = inline;
        }

        @Override
        public void handle(String cmd, Mail m, @Nullable String body, Map<String, ?> params) throws TemplateModelException {
            String nameOrId = MailDirective.getStringParam(params, this.inline ? "id" : "name");
            String type = MailDirective.getStringParam(params, "type", null);
            if (body != null) {
                throw new TemplateModelException("'mail' directive doesn't support embedded attachment content");
            }
            String issFactoryName = null;
            InputStreamSupplier content = null;
            for (Map.Entry<String, ISSFactory> issFactory : ISS_FACTORIES.entrySet()) {
                String param = MailDirective.getStringParam(params, issFactory.getKey(), null);
                if (param == null) continue;
                if (issFactoryName != null) {
                    throw new TemplateModelException("'mail' directive can't have both '" + issFactoryName + "' and '" + issFactory.getKey() + "' parameters set");
                }
                issFactoryName = issFactory.getKey();
                content = issFactory.getValue().create(param);
            }
            if (content == null) {
                throw new TemplateModelException("'mail' directive: one of 'file', 'resource' or 'url' parameters must be present");
            }
            if (this.inline) {
                m.inline(content, nameOrId, type);
            } else {
                m.attachment(content, nameOrId, type);
            }
        }

        static {
            HashMap<String, ISSFactory> m = new HashMap<String, ISSFactory>();
            m.put("file", new FileISSFactory());
            m.put("resource", new ResourceISSFactory());
            m.put("url", new UrlISSFactory());
            ISS_FACTORIES = Collections.unmodifiableMap(m);
        }

        private static class UrlISSFactory
        implements ISSFactory {
            private UrlISSFactory() {
            }

            @Override
            public InputStreamSupplier create(String param) {
                return InputStreamSuppliers.url((String)param);
            }
        }

        private static class ResourceISSFactory
        implements ISSFactory {
            private ResourceISSFactory() {
            }

            @Override
            public InputStreamSupplier create(String param) {
                return InputStreamSuppliers.resource((String)param);
            }
        }

        private static class FileISSFactory
        implements ISSFactory {
            private FileISSFactory() {
            }

            @Override
            public InputStreamSupplier create(String param) {
                return InputStreamSuppliers.file((String)param);
            }
        }

        private static interface ISSFactory {
            public InputStreamSupplier create(String var1);
        }
    }

    private static class AddressHandler
    implements Handler {
        private final AddressType type;

        public AddressHandler(AddressType type) {
            this.type = type;
        }

        @Override
        public void handle(String cmd, Mail m, @Nullable String body, Map<String, ?> params) throws TemplateModelException {
            String address = MailDirective.getStringParam(params, "address", null);
            String personal = MailDirective.getStringParam(params, "personal", null);
            if (address != null) {
                if (body != null) {
                    throw new TemplateModelException("'mail' directive: 'address' parameter and body can't be both present");
                }
                m.address(this.type, address, personal);
            } else {
                if (body == null) {
                    throw new TemplateModelException("'mail' directive: body must be present when 'address' parameter is omitted");
                }
                if (personal != null) {
                    throw new TemplateModelException("'mail' directive: 'personal' parameter may not be specified when there's no 'address' parameter");
                }
                m.address(this.type, body);
            }
        }
    }

    private static class PriorityHandler
    implements Handler {
        private PriorityHandler() {
        }

        @Override
        public void handle(String cmd, Mail m, @Nullable String body, Map<String, ?> params) throws TemplateModelException {
            int priority = MailDirective.getIntParam(params, "value");
            m.priority(priority);
        }
    }

    private static class BodyHandler
    implements Handler {
        private final BodyType type;

        public BodyHandler(BodyType type) {
            this.type = type;
        }

        public BodyType getType() {
            return this.type;
        }

        @Override
        public void handle(String cmd, Mail m, @Nullable String body, Map<String, ?> params) throws TemplateModelException {
            m.body(this.type, body != null ? body : "");
        }
    }

    private static class SubjectHandler
    implements Handler {
        private SubjectHandler() {
        }

        @Override
        public void handle(String cmd, Mail m, @Nullable String body, Map<String, ?> params) throws TemplateModelException {
            String subject = MailDirective.getStringParam(params, "value");
            m.subject(subject);
        }
    }

    private static class SettingsHandler
    implements Handler {
        private SettingsHandler() {
        }

        @Override
        public void handle(String cmd, Mail m, @Nullable String body, Map<String, ?> params) throws TemplateModelException {
            Encoding attachmentEncoding;
            Encoding bodyEncoding;
            Charset charset = MailDirective.getCharsetParam(params, "charset", null);
            if (charset != null) {
                m.charset(charset);
            }
            if ((bodyEncoding = MailDirective.getEncodingParam(params, "body_encoding", Mail.DEFAULT_BODY_ENCODING)) != null) {
                m.bodyEncoding(bodyEncoding);
            }
            if ((attachmentEncoding = MailDirective.getEncodingParam(params, "attachment_encoding", Mail.DEFAULT_BODY_ENCODING)) != null) {
                m.attachmentEncoding(bodyEncoding);
            }
        }
    }

    private static interface Handler {
        public void handle(String var1, Mail var2, @Nullable String var3, Map<String, ?> var4) throws TemplateModelException;
    }

    private static enum TrimMode {
        none,
        leading,
        trailing,
        both;

    }
}

