/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.freemarker;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.emphased.malle.Mail;
import net.emphased.malle.MailIOException;
import net.emphased.malle.template.MailTemplate;
import net.emphased.malle.template.MailTemplateEngine;
import net.emphased.malle.template.freemarker.FreemarkerTemplate;
import net.emphased.malle.template.freemarker.MailDirective;
import net.emphased.malle.template.freemarker.NoopWriter;
import net.emphased.malle.template.freemarker.ObjectModel;
import net.emphased.malle.template.freemarker.Utils;
import net.emphased.malle.util.Preconditions;

public class FreemarkerTemplateEngine
implements MailTemplateEngine {
    static final String MESSAGE_VAR = "__malle_mail";
    private Configuration configuration;

    public MailTemplate getTemplate(Reader source, String name) {
        try {
            return new FreemarkerTemplate(this, new Template(name, source, this.configuration));
        }
        catch (IOException e) {
            throw new MailIOException((Throwable)e);
        }
    }

    public MailTemplate getTemplate(String name, @Nullable Locale locale) {
        try {
            return this.createFreemarkerTemplate(this.configuration.getTemplate(name, locale));
        }
        catch (IOException e) {
            throw new MailIOException((Throwable)e);
        }
    }

    public MailTemplate getTemplate(String name) {
        return this.getTemplate(name, null);
    }

    void applyTemplate(FreemarkerTemplate template, Mail message, @Nullable Map<String, ?> context) {
        Preconditions.checkNotNull((Object)template, (Object)"The 'template' must not be null");
        Preconditions.checkNotNull((Object)message, (Object)"The 'message' must not be null");
        HashMap model = new HashMap(context != null ? context : Collections.emptyMap());
        model.put(MESSAGE_VAR, new ObjectModel(message));
        try {
            Environment env = template.getTemplate().createProcessingEnvironment(model, (Writer)NoopWriter.INSTANCE, null);
            this.configureEnvironment(env, template, message, context);
            env.process();
        }
        catch (TemplateException e) {
            throw Utils.wrapException(e);
        }
        catch (IOException e) {
            throw new MailIOException((Throwable)e);
        }
    }

    public void setConfiguration(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"The 'configuration' must not be null");
        this.configuration = (Configuration)configuration.clone();
        this.configure();
    }

    public FreemarkerTemplateEngine withConfiguration(Configuration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    private void configure() {
        HashMap<String, MailDirective> vars = new HashMap<String, MailDirective>();
        vars.put("mail", new MailDirective());
        try {
            this.configuration.setSharedVaribles(vars);
        }
        catch (TemplateModelException e) {
            throw Utils.wrapException((TemplateException)((Object)e));
        }
    }

    private FreemarkerTemplate createFreemarkerTemplate(Template template) {
        return new FreemarkerTemplate(this, template);
    }

    private void configureEnvironment(Environment env, FreemarkerTemplate template, Mail message, Map<String, ?> context) {
    }
}

