/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.maple.proxies;

import java.util.ArrayList;
import net.emaze.maple.proxies.CglibProxyInspector;
import net.emaze.maple.proxies.HibernateProxyInspector;
import net.emaze.maple.proxies.JavassistProxyInspector;
import net.emaze.maple.proxies.ProxyInspector;
import net.emaze.maple.proxies.SpringCglibProxyInspector;

public class ProxyInspectors {
    private final ProxyInspector[] inspectors;

    public ProxyInspectors(ProxyInspector[] inspectors) {
        this.inspectors = inspectors;
    }

    public static ProxyInspectors detect() {
        ArrayList<ProxyInspector> inspectors = new ArrayList<ProxyInspector>();
        if (ProxyInspectors.isPresent("org.hibernate.proxy.HibernateProxy")) {
            inspectors.add(new HibernateProxyInspector());
        }
        if (ProxyInspectors.isPresent("javassist.util.proxy.ProxyFactory")) {
            inspectors.add(new JavassistProxyInspector());
        }
        if (ProxyInspectors.isPresent("org.springframework.cglib.proxy.Enhancer")) {
            inspectors.add(new SpringCglibProxyInspector());
        }
        if (ProxyInspectors.isPresent("net.sf.cglib.proxy.Enhancer")) {
            inspectors.add(new CglibProxyInspector());
        }
        return new ProxyInspectors(inspectors.toArray(new ProxyInspector[0]));
    }

    public <T> Class<?> inspect(Object source) {
        if (source == null) {
            return null;
        }
        for (ProxyInspector inspector : this.inspectors) {
            if (!inspector.supports(source)) continue;
            return inspector.inspect(source);
        }
        return source.getClass();
    }

    private static boolean isPresent(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException ex) {
            try {
                int lastDot = name.lastIndexOf(46);
                if (lastDot == -1) {
                    return false;
                }
                Class.forName(name.substring(0, lastDot) + '$' + name.substring(lastDot + 1));
                return true;
            }
            catch (ClassNotFoundException ex2) {
                return false;
            }
        }
    }
}

