/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.maple.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.maple.Converter;
import net.emaze.maple.Converters;
import org.springframework.core.ResolvableType;

public class IterableToIterableConverter
implements Converter {
    @Override
    public boolean canConvert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        return Iterable.class.isAssignableFrom(sourceType.resolve()) && Iterable.class.isAssignableFrom(targetType.resolve());
    }

    @Override
    public Maybe<?> convert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        Class sourceClass = sourceType.resolve();
        Class targetClass = targetType.resolve();
        Maybe<Collection<Object>> maybeCollection = IterableToIterableConverter.createCollection(targetClass);
        if (!maybeCollection.hasValue()) {
            return Maybe.nothing();
        }
        Collection collection = (Collection)maybeCollection.value();
        ResolvableType targetElementType = targetType.getGeneric(new int[]{0});
        ResolvableType sourceElementType = sourceType.getGeneric(new int[]{0});
        for (Object object : (Iterable)source) {
            Maybe<?> el = converters.convert(sourceElementType, object, targetElementType);
            if (!el.hasValue()) {
                return Maybe.nothing();
            }
            collection.add(el.value());
        }
        return Maybe.just((Object)collection);
    }

    private static Maybe<Collection<Object>> createCollection(Class<?> targetClass) {
        if (Deque.class.isAssignableFrom(targetClass)) {
            return Maybe.just(new LinkedList());
        }
        if (List.class.isAssignableFrom(targetClass)) {
            return Maybe.just(new ArrayList());
        }
        if (SortedSet.class.isAssignableFrom(targetClass)) {
            return Maybe.just(new TreeSet());
        }
        if (Set.class.isAssignableFrom(targetClass)) {
            return Maybe.just(new HashSet());
        }
        return Maybe.nothing();
    }
}

