/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.maple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.emaze.dysfunctional.Applications;
import net.emaze.dysfunctional.options.Either;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.tuples.Pair;
import net.emaze.dysfunctional.tuples.Triple;

public interface Mapper {
    public <R> R map(Object var1, Class<R> var2);

    default public <R, T> List<R> map(Iterable<T> source, Class<R> elementClass) {
        ArrayList<R> target = new ArrayList<R>();
        for (T s : source) {
            target.add(this.map(s, elementClass));
        }
        return target;
    }

    default public <R, T> List<R> map(Iterable<T> source, Class<R> elementClass, BiConsumer<R, T> callback) {
        ArrayList<R> target = new ArrayList<R>();
        for (T s : source) {
            R mapped = this.map(s, elementClass);
            callback.accept(mapped, s);
            target.add(mapped);
        }
        return target;
    }

    default public <R, T, C extends Collection<R>> C map(Iterable<T> source, C target, Class<R> elementClass) {
        for (T s : source) {
            target.add(this.map(s, elementClass));
        }
        return target;
    }

    default public <R, T, C extends Collection<R>> C map(Iterable<T> source, C target, Class<R> elementClass, BiConsumer<R, T> callback) {
        for (T s : source) {
            R mapped = this.map(s, elementClass);
            callback.accept(mapped, s);
            target.add(mapped);
        }
        return target;
    }

    default public <R, T> Iterator<R> map(Iterator<T> source, Class<R> elementClass) {
        return Applications.transform(source, s -> this.map(s, elementClass));
    }

    default public <R, T> Iterator<R> map(Iterator<T> source, Class<R> elementClass, BiConsumer<R, T> callback) {
        return Applications.transform(source, s -> {
            Object t = this.map(s, elementClass);
            callback.accept(t, s);
            return t;
        });
    }

    default public <R, T> Stream<R> map(Stream<T> source, Class<R> elementClass) {
        return source.map(s -> this.map(s, elementClass));
    }

    default public <R, T> Stream<R> map(Stream<T> source, Class<R> elementClass, BiConsumer<R, T> callback) {
        return source.map(s -> {
            Object t = this.map(s, elementClass);
            callback.accept(t, s);
            return t;
        });
    }

    default public <RV, K, V> Map<K, RV> map(Map<K, V> source, Class<RV> elementClass) {
        HashMap<K, RV> result = new HashMap<K, RV>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            result.put(entry.getKey(), this.map(entry.getValue(), elementClass));
        }
        return result;
    }

    default public <RV, K, V> Map<K, RV> map(Map<K, V> source, Class<RV> elementClass, BiConsumer<RV, V> callback) {
        HashMap<K, RV> result = new HashMap<K, RV>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            V value = entry.getValue();
            RV mapped = this.map(value, elementClass);
            callback.accept(mapped, value);
            result.put(entry.getKey(), mapped);
        }
        return result;
    }

    default public <RL, RR, SL, SR> Either<RL, RR> map(Either<SL, SR> source, Class<RL> leftClass, Class<RR> rightClass) {
        if (source.maybe().hasValue()) {
            return Either.right((Object)source.maybe().fmap(r -> this.map(r, rightClass)).value());
        }
        return Either.left((Object)source.flip().maybe().fmap(l -> this.map(l, leftClass)).value());
    }

    default public <R1, R2, T1, T2> Pair<R1, R2> map(Pair<T1, T2> source, Class<R1> firstClass, Class<R2> secondClass) {
        return source.fmap(f -> this.map(f, firstClass), s -> this.map(s, secondClass));
    }

    default public <R1, R2, R3, T1, T2, T3> Triple<R1, R2, R3> map(Triple<T1, T2, T3> source, Class<R1> firstClass, Class<R2> secondClass, Class<R3> thirdClass) {
        return source.fmap(f -> this.map(f, firstClass), s -> this.map(s, secondClass), t -> this.map(t, thirdClass));
    }

    default public <R, T> Maybe<R> map(Maybe<T> source, Class<R> elementClass) {
        return source.fmap(s -> this.map(s, elementClass));
    }

    default public <R, T> Optional<R> map(Optional<T> source, Class<R> elementClass) {
        return source.map(s -> this.map(s, elementClass));
    }
}

