package net.emaze.maple.converters;

import net.emaze.dysfunctional.options.Maybe;
import net.emaze.maple.Converter;
import net.emaze.maple.Converters;
import org.springframework.core.ResolvableType;


public class ToByteConverter implements Converter {

    @Override
    public boolean canConvert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        final Class<?> targetClass = targetType.resolve();
        return targetClass == Byte.class || targetClass == byte.class;
    }

    @Override
    public Maybe<?> convert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        if(source instanceof CharSequence){
            return Maybe.just(Byte.parseByte(source.toString()));
        }
        if(source instanceof Number){
            return Maybe.just(((Number) source).byteValue());
        }
        return Maybe.nothing();
    }

    
}
