/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.tuples;

import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;

public class Triple<T1, T2, T3> {
    private final T1 f;
    private final T2 s;
    private final T3 t;

    public Triple(T1 first, T2 second, T3 third) {
        this.f = first;
        this.s = second;
        this.t = third;
    }

    public T1 first() {
        return this.f;
    }

    public T2 second() {
        return this.s;
    }

    public T3 third() {
        return this.t;
    }

    public Triple<T3, T2, T1> flip() {
        return Triple.of(this.t, this.s, this.f);
    }

    public Triple<T2, T3, T1> rotateLeft() {
        return Triple.of(this.s, this.t, this.f);
    }

    public Triple<T3, T1, T2> rotateRight() {
        return Triple.of(this.t, this.f, this.s);
    }

    public <R1, R2, R3> Triple<R1, R2, R3> map(Function<T1, R1> withFirst, Function<T2, R2> withSecond, Function<T3, R3> withThird) {
        dbc.precondition(withFirst != null, "cannot fmap on triple with a null first function", new Object[0]);
        dbc.precondition(withSecond != null, "cannot fmap on triple with a null second function", new Object[0]);
        dbc.precondition(withThird != null, "cannot fmap on triple with a null second function", new Object[0]);
        return Triple.of(withFirst.apply(this.f), withSecond.apply(this.s), withThird.apply(this.t));
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)rhs;
        return new EqualsBuilder().append(this.f, other.f).append(this.s, other.s).append(this.t, other.t).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.f).append(this.s).append(this.t).toHashCode();
    }

    public String toString() {
        return String.format("(%s,%s,%s)", this.f, this.s, this.t);
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }
}

