/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.time;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.time.TimeStrategy;
import net.emaze.dysfunctional.tuples.Pair;

public class TimeStrategyToMillisSupplier
implements Supplier<Long> {
    private final TimeStrategy timeStrategy;

    public TimeStrategyToMillisSupplier(TimeStrategy timeStrategy) {
        dbc.precondition(timeStrategy != null, "cannot create a MillisSupplier with a null timeStrategy", new Object[0]);
        this.timeStrategy = timeStrategy;
    }

    @Override
    public Long get() {
        Pair<Long, TimeUnit> currentTime = this.timeStrategy.currentTime();
        return TimeUnit.MILLISECONDS.convert(currentTime.first(), currentTime.second());
    }
}

