/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class LongParser
implements Function<String, Long> {
    private final int radix;

    public LongParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Long apply(String parsee) {
        dbc.precondition(parsee != null, "cannot parse a null string", new Object[0]);
        return Long.parseLong(parsee, this.radix);
    }
}

