/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class ByteParser
implements Function<String, Byte> {
    private final int radix;

    public ByteParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Byte apply(String parsee) {
        dbc.precondition(parsee != null, "cannot parse a null string", new Object[0]);
        return Byte.parseByte(parsee, this.radix);
    }
}

