/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings;

import java.util.Iterator;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.multiplexing.ChainIterator;
import net.emaze.dysfunctional.strings.JoinStrings;
import net.emaze.dysfunctional.strings.ToLowerCase;
import net.emaze.dysfunctional.strings.ToTitleCase;

public class WordsToCamelCase
implements Function<String[], String> {
    private final ToLowerCase toLower = new ToLowerCase();
    private final ToTitleCase toTitle = new ToTitleCase();

    @Override
    public String apply(String[] words) {
        dbc.precondition(words != null, "cannot camelcase a null array of words", new Object[0]);
        if (words.length == 0) {
            return "";
        }
        ArrayIterator<String> iter = new ArrayIterator<String>(words);
        SingletonIterator<String> head = new SingletonIterator<String>(this.toLower.apply((String)iter.next()));
        TransformingIterator<String, String> tail = new TransformingIterator<String, String>(iter, this.toTitle);
        ArrayIterator<Iterator> ht = ArrayIterator.of(head, tail);
        ChainIterator chained = new ChainIterator(ht);
        return new JoinStrings().apply(chained);
    }
}

