/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.sequences;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.emaze.dysfunctional.consumers.FirstElement;
import net.emaze.dysfunctional.consumers.LastElement;
import net.emaze.dysfunctional.consumers.MaybeLastElement;
import net.emaze.dysfunctional.consumers.MaybeOneElement;
import net.emaze.dysfunctional.consumers.OneElement;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Tapper;
import net.emaze.dysfunctional.filtering.AtIndex;
import net.emaze.dysfunctional.filtering.AtMostMemoryIterator;
import net.emaze.dysfunctional.filtering.DropWhile;
import net.emaze.dysfunctional.filtering.MemoryIterator;
import net.emaze.dysfunctional.filtering.Nth;
import net.emaze.dysfunctional.filtering.TakeUpToIterator;
import net.emaze.dysfunctional.filtering.TakeWhileIterator;
import net.emaze.dysfunctional.filtering.UntilCount;
import net.emaze.dysfunctional.sequences.DefaultSequence;

public interface Sequence<T>
extends Stream<T> {
    public static <T> Sequence<T> from(Iterator<T> iterator) {
        dbc.precondition(iterator != null, "Cannot create a sequence from a null iterator", new Object[0]);
        Spliterator<T> splitIterator = Spliterators.spliteratorUnknownSize(iterator, 16);
        return new DefaultSequence<T>(StreamSupport.stream(splitIterator, false));
    }

    public static <T> Sequence<T> from(Stream<T> stream) {
        dbc.precondition(stream != null, "Cannot create a sequence from a null stream", new Object[0]);
        return stream instanceof Sequence ? (Sequence<T>)stream : new DefaultSequence<T>(stream);
    }

    @Override
    default public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    default public Set<T> toSet() {
        return this.collect(Collectors.toSet());
    }

    default public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        dbc.precondition(keyMapper != null, "Cannot use a null key mapper function", new Object[0]);
        dbc.precondition(valueMapper != null, "Cannot use a null value mapper function", new Object[0]);
        return this.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    default public <K> Sequence<T> distinctBy(Function<? super T, ? extends K> propertyMapper) {
        dbc.precondition(propertyMapper != null, "Cannot use a null property mapper function", new Object[0]);
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(propertyMapper.apply(t)));
    }

    default public T first() {
        return (T)new FirstElement<T>().apply(this.iterator());
    }

    default public Optional<T> maybeFirst() {
        return this.findFirst();
    }

    default public T one() {
        return (T)new OneElement<T>().apply(this.iterator());
    }

    default public Optional<T> maybeOne() {
        return new MaybeOneElement<T>().apply(this.iterator());
    }

    default public T last() {
        return (T)new LastElement<T>().apply(this.iterator());
    }

    default public Optional<T> maybeLast() {
        return new MaybeLastElement<T>().apply(this.iterator());
    }

    default public T nth(long count) {
        Stream filtered = this.filter((Predicate)new Nth(count));
        return (T)new FirstElement<T>().apply(filtered.iterator());
    }

    default public Optional<T> maybeNth(long count) {
        return this.filter((Predicate)new Nth(count)).findFirst();
    }

    default public T at(long index) {
        Stream filtered = this.filter((Predicate)new AtIndex(index));
        return (T)new FirstElement<T>().apply(filtered.iterator());
    }

    default public Optional<T> maybeAt(long index) {
        return this.filter((Predicate)new AtIndex(index)).findFirst();
    }

    default public Sequence<T> take(int howMany) {
        TakeUpToIterator<T> iterator = new TakeUpToIterator<T>(this.iterator(), howMany);
        return Sequence.from(iterator);
    }

    default public Sequence<T> takeLast(int howMany) {
        MemoryIterator<T> iterator = new MemoryIterator<T>(this.iterator(), howMany);
        return Sequence.from(iterator);
    }

    default public Sequence<T> takeAtMostLast(int howMany) {
        AtMostMemoryIterator<T> iterator = new AtMostMemoryIterator<T>(this.iterator(), howMany);
        return Sequence.from(iterator);
    }

    @Override
    default public Sequence<T> takeWhile(Predicate<T> predicate) {
        TakeWhileIterator<T> iterator = new TakeWhileIterator<T>(this.iterator(), predicate);
        return Sequence.from(iterator);
    }

    default public Sequence<T> drop(long howMany) {
        return this.filter((Predicate)new DropWhile(new UntilCount(howMany)));
    }

    @Override
    default public Sequence<T> dropWhile(Predicate<T> predicate) {
        return this.filter(new DropWhile<T>(predicate));
    }

    default public Sequence<T> slice(long from, long howMany) {
        return this.drop(from).take((int)howMany);
    }

    default public Sequence<T> chain(Stream<T> other) {
        return Sequence.from(Stream.concat(this, other));
    }

    default public Sequence<T> tap(Consumer<? super T> consumer) {
        return this.map(new Tapper<T>(consumer));
    }

    @Override
    public boolean allMatch(Predicate<? super T> var1);

    @Override
    public boolean anyMatch(Predicate<? super T> var1);

    @Override
    public void close();

    @Override
    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    @Override
    public <R, A> R collect(Collector<? super T, A, R> var1);

    @Override
    public long count();

    @Override
    public Sequence<T> distinct();

    @Override
    public Sequence<T> filter(Predicate<? super T> var1);

    @Override
    public Optional<T> findAny();

    @Override
    public Optional<T> findFirst();

    @Override
    public <R> Sequence<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    @Override
    public void forEach(Consumer<? super T> var1);

    @Override
    public void forEachOrdered(Consumer<? super T> var1);

    @Override
    public boolean isParallel();

    @Override
    public Iterator<T> iterator();

    @Override
    public Sequence<T> limit(long var1);

    @Override
    public <R> Sequence<R> map(Function<? super T, ? extends R> var1);

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> var1);

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> var1);

    @Override
    public Optional<T> max(Comparator<? super T> var1);

    @Override
    public Optional<T> min(Comparator<? super T> var1);

    @Override
    public boolean noneMatch(Predicate<? super T> var1);

    @Override
    public Sequence<T> onClose(Runnable var1);

    @Override
    public Sequence<T> parallel();

    @Override
    public Sequence<T> peek(Consumer<? super T> var1);

    @Override
    public T reduce(T var1, BinaryOperator<T> var2);

    @Override
    public Optional<T> reduce(BinaryOperator<T> var1);

    @Override
    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    @Override
    public Sequence<T> sequential();

    @Override
    public Sequence<T> skip(long var1);

    @Override
    public Sequence<T> sorted();

    @Override
    public Sequence<T> sorted(Comparator<? super T> var1);

    @Override
    public Spliterator<T> spliterator();

    @Override
    public Object[] toArray();

    @Override
    public <A> A[] toArray(IntFunction<A[]> var1);

    @Override
    public Sequence<T> unordered();
}

