/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.reductions;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class Reductor<E, R>
implements Function<Iterator<E>, R> {
    private final BiFunction<R, E, R> function;
    private final R init;

    public Reductor(BiFunction<R, E, R> function, R init) {
        dbc.precondition(function != null, "cannot create a Reductor with a null function", new Object[0]);
        this.function = function;
        this.init = init;
    }

    @Override
    public R apply(Iterator<E> iterator) {
        dbc.precondition(iterator != null, "consuming a null iterator", new Object[0]);
        R current = this.init;
        while (iterator.hasNext()) {
            current = this.function.apply(current, iterator.next());
        }
        return current;
    }
}

