/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.BinaryOperator;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.Difference;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.ranges.Union;

public class SymmetricDifference<T>
implements BinaryOperator<Range<T>> {
    private final Union<T> union;
    private final Difference<T> diff;

    public SymmetricDifference(SequencingPolicy<T> sequencer, Comparator<Optional<T>> comparator, T emptyValue) {
        this.union = new Union<T>(sequencer, comparator, emptyValue);
        this.diff = new Difference<T>(sequencer, comparator, emptyValue);
    }

    @Override
    public Range<T> apply(Range<T> lhs, Range<T> rhs) {
        return this.union.apply(this.diff.apply(lhs, rhs), this.diff.apply(rhs, lhs));
    }
}

