/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ConstantIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.multiplexing.ChainIterator;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.ranges.RangeComparator;
import net.emaze.dysfunctional.ranges.RangeNotContaining;
import net.emaze.dysfunctional.ranges.RangeOverlappingWith;
import net.emaze.dysfunctional.reductions.Any;
import net.emaze.dysfunctional.strings.InterposeStrings;

public class SparseRange<T>
implements Range<T> {
    private final List<DenseRange<T>> densified;
    private final Comparator<Optional<T>> comparator;

    public SparseRange(SequencingPolicy<T> sequencer, Comparator<Optional<T>> comparator, List<DenseRange<T>> densified) {
        dbc.precondition(sequencer != null, "trying to create a SparseRange<T> with a null SequencingPolicy<T>", new Object[0]);
        dbc.precondition(comparator != null, "trying to create a SparseRange<T> with a null Comparator<T>", new Object[0]);
        dbc.precondition(densified != null, "trying to create a SparseRange<T> from a null ranges", new Object[0]);
        dbc.precondition(!densified.isEmpty(), "trying to create a SparseRange<T> from zero non-empty ranges", new Object[0]);
        dbc.precondition(densified.size() > 1, "trying to create a SparseRange<T> when a DenseRange<T> should be created", new Object[0]);
        this.densified = densified;
        this.comparator = comparator;
    }

    @Override
    public boolean contains(T element) {
        return new Any<DenseRange<T>>(new RangeNotContaining<T>(element)).test(this.densified.iterator());
    }

    @Override
    public T begin() {
        return this.densified.get(0).begin();
    }

    @Override
    public Optional<T> end() {
        return this.densified.get(this.densified.size() - 1).end();
    }

    @Override
    public int compareTo(Range<T> other) {
        dbc.precondition(other != null, "Comparing (compareTo) a SparseRange<T>(%s) with null", new Object[0]);
        return new RangeComparator<T>(this.comparator).compare(this, other);
    }

    @Override
    public Iterator<T> iterator() {
        return new ChainIterator(new TransformingIterator<DenseRange, Iterator>(this.densified.iterator(), Iterable::iterator));
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof SparseRange)) {
            return false;
        }
        SparseRange other = (SparseRange)rhs;
        return this.densified.equals(other.densified);
    }

    public int hashCode() {
        return this.densified.hashCode();
    }

    public String toString() {
        String interposed = new InterposeStrings<DenseRange<T>, String>().apply(this.densified.iterator(), new ConstantIterator<String>(","));
        return String.format("[%s]", interposed);
    }

    @Override
    public boolean overlaps(Range<T> other) {
        dbc.precondition(other != null, "checking for overlaps between a SparseRange<T> and null", new Object[0]);
        return new Any<DenseRange<T>>(new RangeOverlappingWith(other)).test(this.densified.iterator());
    }

    @Override
    public List<DenseRange<T>> densified() {
        return this.densified;
    }
}

