/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.order.SequencingPolicy;

public class RangeIterator<T>
implements Iterator<T> {
    private final SequencingPolicy<T> policy;
    private T current;
    private final Optional<T> end;
    private Comparator<Optional<T>> comparator;

    public RangeIterator(SequencingPolicy<T> policy, Comparator<Optional<T>> comparator, T begin, Optional<T> end) {
        dbc.precondition(policy != null, "trying to create a RangeIterator from a null policy", new Object[0]);
        dbc.precondition(comparator != null, "trying to create a RangeIterator from a null comparator", new Object[0]);
        dbc.precondition(begin != null, "trying to create a RangeIterator from a null start", new Object[0]);
        dbc.precondition(end != null, "trying to create a RangeIterator from a null upTo", new Object[0]);
        this.policy = policy;
        this.current = begin;
        this.end = end;
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        return Order.of(this.comparator, Optional.of(this.current), this.end).isLt();
    }

    @Override
    public T next() {
        T oldCurrent = this.current;
        this.current = this.policy.next(this.current).get();
        return oldCurrent;
    }

    @Override
    public void remove() {
    }
}

