/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BinaryOperator;
import net.emaze.dysfunctional.order.MakeOrder;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.MakeRange;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.tuples.Pair;

public class Intersection<T>
implements BinaryOperator<Range<T>> {
    private final SequencingPolicy<T> sequencer;
    private final Comparator<Optional<T>> comparator;
    private final T emptyValue;

    public Intersection(SequencingPolicy<T> sequencer, Comparator<Optional<T>> comparator, T emptyValue) {
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.emptyValue = emptyValue;
    }

    @Override
    public Range<T> apply(Range<T> lhs, Range<T> rhs) {
        ArrayList intersection = new ArrayList();
        MakeOrder<Optional<T>> makeOrder = new MakeOrder<Optional<T>>(this.comparator);
        for (DenseRange<T> l : lhs.densified()) {
            for (DenseRange<T> r : rhs.densified()) {
                if (!l.overlaps(r)) continue;
                Object orderedLowerBounds = makeOrder.apply((Object)Optional.of(l.begin()), (Object)Optional.of(r.begin()));
                Object orderedUpperBounds = makeOrder.apply((Object)l.end(), (Object)r.end());
                intersection.add(new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, ((Optional)((Pair)orderedLowerBounds).second()).get(), (Optional)((Pair)orderedUpperBounds).first(), Range.Endpoint.Exclude));
            }
        }
        return new MakeRange(this.sequencer, this.comparator, this.emptyValue).apply(intersection);
    }
}

