/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Iterator;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class OptionalIterator<E>
extends ReadOnlyIterator<Optional<E>> {
    private final Iterator<E> iterator;

    public OptionalIterator(Iterator<E> iterator) {
        dbc.precondition(iterator != null, "trying to create a OptionalIterator from a null iterator", new Object[0]);
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Optional<E> next() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }
}

