/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;
import net.emaze.dysfunctional.iterations.EmptyIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.options.Either;

public class Maybe<E>
implements Iterable<E> {
    private final E element;
    private final boolean hasValue;
    private static Maybe<Object> NOTHING = new Maybe<Object>(null, false);

    public Maybe(E element, boolean hasValue) {
        this.element = element;
        this.hasValue = hasValue;
    }

    public boolean isPresent() {
        return this.hasValue;
    }

    public E get() {
        dbc.state(this.hasValue, "fetching value from nothing", new Object[0]);
        return this.element;
    }

    public <T> Maybe<T> map(Function<E, T> function) {
        dbc.precondition(function != null, "cannot perform fmap with a null function", new Object[0]);
        if (this.hasValue) {
            return Maybe.just(function.apply(this.element));
        }
        return Maybe.nothing();
    }

    public <T> T fold(Supplier<T> ifNothing, Function<E, T> ifJust) {
        dbc.precondition(ifJust != null, "cannot perform fold with a null function", new Object[0]);
        return this.hasValue ? ifJust.apply(this.element) : ifNothing.get();
    }

    public <T> Either<T, E> either(Supplier<T> nothing) {
        if (this.hasValue) {
            return Either.right(this.element);
        }
        return Either.left(nothing.get());
    }

    public E orElse(E otherwise) {
        if (this.hasValue) {
            return this.element;
        }
        return otherwise;
    }

    public Optional<E> optional() {
        if (this.hasValue) {
            return Optional.ofNullable(this.element);
        }
        return Optional.empty();
    }

    public Maybe<E> orElse(Maybe<E> otherwise) {
        if (this.hasValue) {
            return this;
        }
        return otherwise;
    }

    public static <E> Maybe<E> nothing() {
        return NOTHING;
    }

    public static <E> Maybe<E> just(E element) {
        return new Maybe<E>(element, true);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.hasValue).append(this.element).toHashCode();
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Maybe)) {
            return false;
        }
        Maybe other = (Maybe)rhs;
        return new EqualsBuilder().append(this.hasValue, other.hasValue).append(this.element, other.element).isEquals();
    }

    public String toString() {
        if (!this.hasValue) {
            return "Nothing";
        }
        return String.format("Just %s", this.element);
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.hasValue) {
            return new EmptyIterator();
        }
        return new SingletonIterator<E>(this.element);
    }
}

