/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.numbers;

import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.numbers.policies.ModulusPolicy;

public class IsOdd<R, T>
implements Predicate<T> {
    private final ModulusPolicy<R, T, Integer> policy;
    private final R zero;

    public IsOdd(ModulusPolicy<R, T, Integer> policy, R zero) {
        dbc.precondition(policy != null, "cannot create IsOdd with a null modulus policy", new Object[0]);
        this.policy = policy;
        this.zero = zero;
    }

    @Override
    public boolean test(T value) {
        return !this.policy.modulus(value, 2).equals(this.zero);
    }
}

