/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.numbers;

import java.util.function.BiFunction;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.numbers.policies.SumPolicy;
import net.emaze.dysfunctional.tuples.Pair;

public class Average<T>
implements BiFunction<Pair<T, Long>, T, Pair<T, Long>> {
    private final SumPolicy<T, T, T> policy;

    public Average(SumPolicy<T, T, T> policy) {
        dbc.precondition(policy != null, "cannot create Average with a null sum policy", new Object[0]);
        this.policy = policy;
    }

    @Override
    public Pair<T, Long> apply(Pair<T, Long> accumulator, T value) {
        T sum = this.policy.sum(accumulator.first(), value);
        long count = accumulator.second() + 1L;
        return Pair.of(sum, count);
    }
}

