/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.iterations;

import java.util.NoSuchElementException;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class SingletonIterator<T>
extends ReadOnlyIterator<T> {
    private final T element;
    private boolean isConsumed;

    public SingletonIterator(T element) {
        this.element = element;
    }

    @Override
    public boolean hasNext() {
        return !this.isConsumed;
    }

    @Override
    public T next() {
        if (this.isConsumed) {
            throw new NoSuchElementException("singleton iterator is already consumed");
        }
        this.isConsumed = true;
        return this.element;
    }
}

