/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.interceptions;

import java.util.function.BiFunction;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.interceptions.BinaryInterceptor;

public class BinaryInterceptorAdapter<T1, T2, R>
implements BiFunction<T1, T2, R> {
    private final BinaryInterceptor<T1, T2> interceptor;
    private final BiFunction<T1, T2, R> inner;

    public BinaryInterceptorAdapter(BinaryInterceptor<T1, T2> interceptor, BiFunction<T1, T2, R> inner) {
        dbc.precondition(interceptor != null, "cannot adapt a null interceptor", new Object[0]);
        dbc.precondition(inner != null, "cannot adato with a null inner function", new Object[0]);
        this.interceptor = interceptor;
        this.inner = inner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R apply(T1 first, T2 second) {
        this.interceptor.before(first, second);
        try {
            R r = this.inner.apply(first, second);
            return r;
        }
        finally {
            this.interceptor.after(first, second);
        }
    }
}

