/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.groups;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;

public class IndexBy<M extends Map<K, V>, K, V>
implements Function<Iterator<V>, M> {
    private final Function<V, K> grouper;
    private final Supplier<M> mapProvider;

    public IndexBy(Function<V, K> grouper, Supplier<M> mapProvider) {
        dbc.precondition(grouper != null, "cannot index with a null grouper", new Object[0]);
        dbc.precondition(mapProvider != null, "cannot index with a null mapProvider", new Object[0]);
        this.grouper = grouper;
        this.mapProvider = mapProvider;
    }

    @Override
    public M apply(Iterator<V> groupies) {
        dbc.precondition(groupies != null, "cannot index with a null iterator", new Object[0]);
        Map grouped = (Map)this.mapProvider.get();
        while (groupies.hasNext()) {
            V groupie = groupies.next();
            K group = this.grouper.apply(groupie);
            grouped.put(group, groupie);
        }
        return (M)grouped;
    }
}

