/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.groups;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;

public class GroupBy<M extends Map<K, C>, C extends Collection<V>, K, V>
implements Function<Iterator<V>, M> {
    private final Function<V, K> grouper;
    private final Supplier<C> collectionProvider;
    private final Supplier<M> mapProvider;

    public GroupBy(Function<V, K> grouper, Supplier<C> collectionProvider, Supplier<M> mapProvider) {
        dbc.precondition(grouper != null, "cannot group with a null grouper", new Object[0]);
        dbc.precondition(collectionProvider != null, "cannot group with a null collectionProvider", new Object[0]);
        dbc.precondition(mapProvider != null, "cannot group with a null mapProvider", new Object[0]);
        this.grouper = grouper;
        this.collectionProvider = collectionProvider;
        this.mapProvider = mapProvider;
    }

    @Override
    public M apply(Iterator<V> groupies) {
        dbc.precondition(groupies != null, "cannot group with a null iterator", new Object[0]);
        Map grouped = (Map)this.mapProvider.get();
        while (groupies.hasNext()) {
            V groupie = groupies.next();
            K group = this.grouper.apply(groupie);
            if (!grouped.containsKey(group)) {
                grouped.put(group, this.collectionProvider.get());
            }
            ((Collection)grouped.get(group)).add(groupie);
        }
        return (M)grouped;
    }
}

