/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.filtering;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class TakeWhileIterator<E>
extends ReadOnlyIterator<E> {
    private final Predicate<E> filter;
    private final Iterator<E> iterator;
    private E prefetched;
    private boolean hasPrefetched;

    public TakeWhileIterator(Iterator<E> iterator, Predicate<E> filter) {
        dbc.precondition(iterator != null, "trying to create a TakeWhileIterator from a null iterator", new Object[0]);
        dbc.precondition(filter != null, "trying to create a TakeWhileIterator from a null filter", new Object[0]);
        this.iterator = iterator;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.hasPrefetched) {
            return true;
        }
        if (!this.iterator.hasNext()) {
            return false;
        }
        E element = this.iterator.next();
        if (this.filter.test(element)) {
            this.prefetched = element;
            this.hasPrefetched = true;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.hasPrefetched) {
            this.hasPrefetched = false;
            return this.prefetched;
        }
        E element = this.iterator.next();
        if (this.filter.test(element)) {
            return element;
        }
        throw new NoSuchElementException();
    }
}

