/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.TriFunction;

public class TernaryMonitoringFunction<T1, T2, T3, R>
implements TriFunction<T1, T2, T3, R> {
    private final TriFunction<T1, T2, T3, R> nested;
    private final AtomicLong calls;

    public TernaryMonitoringFunction(TriFunction<T1, T2, T3, R> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null function", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public R apply(T1 first, T2 second, T3 third) {
        this.calls.incrementAndGet();
        return this.nested.apply(first, second, third);
    }
}

