/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import net.emaze.dysfunctional.contracts.dbc;

public class BinaryMonitoringConsumer<T1, T2>
implements BiConsumer<T1, T2> {
    private final BiConsumer<T1, T2> nested;
    private final AtomicLong calls;

    public BinaryMonitoringConsumer(BiConsumer<T1, T2> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null consumer", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public void accept(T1 former, T2 latter) {
        this.calls.incrementAndGet();
        this.nested.accept(former, latter);
    }
}

