/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.logic;

import net.emaze.dysfunctional.contracts.dbc;

@FunctionalInterface
public interface TriPredicate<T1, T2, T3> {
    public boolean test(T1 var1, T2 var2, T3 var3);

    default public TriPredicate<T1, T2, T3> and(TriPredicate<T1, T2, T3> other) {
        dbc.precondition(other != null, "cannot compose a ternary predicate with a null predicate", new Object[0]);
        return (fst, snd, trd) -> this.test(fst, snd, trd) && other.test(fst, snd, trd);
    }

    default public TriPredicate<T1, T2, T3> negate() {
        return (fst, snd, trd) -> !this.test(fst, snd, trd);
    }

    default public TriPredicate<T1, T2, T3> or(TriPredicate<T1, T2, T3> other) {
        dbc.precondition(other != null, "cannot compose a ternary predicate with a null predicate", new Object[0]);
        return (fst, snd, trd) -> this.test(fst, snd, trd) || other.test(fst, snd, trd);
    }
}

