/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.delegates;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.JavaIntrospector;

public class Pluck<T, R>
implements Function<T, R> {
    private final BiFunction<Class<?>, Class<?>, PropertyDescriptor[]> introspector = new JavaIntrospector();
    private final Method method;

    public Pluck(Class<T> klass, String property) {
        dbc.precondition(klass != null, "cannot pluck from a null class", new Object[0]);
        dbc.precondition(property != null, "cannot pluck a null property from an object", new Object[0]);
        this.method = this.propertyNameToMethod(klass, property);
    }

    @Override
    public R apply(T t) {
        try {
            return (R)this.method.invoke(t, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex.getCause());
        }
    }

    private Method propertyNameToMethod(Class<?> klass, String property) {
        for (PropertyDescriptor pd : this.introspector.apply(klass, Object.class)) {
            if (!property.equals(pd.getName())) continue;
            return pd.getReadMethod();
        }
        throw new IllegalStateException(String.format("property %s is not defined in class %s", property, klass.getSimpleName()));
    }
}

