/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.delegates;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class MemoizingFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> function;
    private final Map<T, R> cache;

    public MemoizingFunction(Function<T, R> function) {
        this(function, new HashMap());
    }

    public MemoizingFunction(Function<T, R> function, Map<T, R> cache) {
        dbc.precondition(function != null, "Cannot create a memoizing function with a null function", new Object[0]);
        dbc.precondition(cache != null, "Cannot create a memoizing function with a null cache", new Object[0]);
        this.function = function;
        this.cache = cache;
    }

    @Override
    public R apply(T t) {
        if (this.cache.containsKey(t)) {
            return this.cache.get(t);
        }
        R result = this.function.apply(t);
        this.cache.put(t, result);
        return result;
    }
}

