/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.delegates;

import java.net.Inet4Address;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class Inet4AddressToLong
implements Function<Inet4Address, Long> {
    @Override
    public Long apply(Inet4Address address) {
        dbc.precondition(address != null, "cannot transform a null Inet4Address to Long", new Object[0]);
        byte[] octets = address.getAddress();
        long longAddress = 0L;
        for (int i = 0; i != octets.length; ++i) {
            longAddress = longAddress << 8 | (long)(octets[i] & 0xFF);
        }
        return longAddress;
    }
}

