/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.composing;

import java.util.function.Consumer;
import net.emaze.dysfunctional.contracts.dbc;

public class PipelinedConsumer<E>
implements Consumer<E> {
    private final Iterable<Consumer<E>> consumers;

    public PipelinedConsumer(Iterable<Consumer<E>> consumers) {
        dbc.precondition(consumers != null, "cannot create a pipeline from a null iterable of consumers", new Object[0]);
        this.consumers = consumers;
    }

    @Override
    public void accept(E value) {
        for (Consumer<E> consumer : this.consumers) {
            consumer.accept(value);
        }
    }
}

