/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.composing;

import java.util.function.BiConsumer;
import net.emaze.dysfunctional.contracts.dbc;

public class PipelinedBinaryConsumer<E1, E2>
implements BiConsumer<E1, E2> {
    private final Iterable<BiConsumer<E1, E2>> consumers;

    public PipelinedBinaryConsumer(Iterable<BiConsumer<E1, E2>> consumers) {
        dbc.precondition(consumers != null, "cannot create a pipeline from a null iterable of binary consumers", new Object[0]);
        this.consumers = consumers;
    }

    @Override
    public void accept(E1 former, E2 latter) {
        for (BiConsumer<E1, E2> consumer : this.consumers) {
            consumer.accept(former, latter);
        }
    }
}

