/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.composing;

import java.util.function.BiPredicate;
import net.emaze.dysfunctional.contracts.dbc;

public class FirstMatchingBinaryPredicate<E1, E2>
implements BiPredicate<E1, E2> {
    private final Iterable<BiPredicate<E1, E2>> predicates;

    public FirstMatchingBinaryPredicate(Iterable<BiPredicate<E1, E2>> predicates) {
        dbc.precondition(predicates != null, "cannot evaluate or(...) of a null iterable of binary predicates", new Object[0]);
        this.predicates = predicates;
    }

    @Override
    public boolean test(E1 first, E2 second) {
        for (BiPredicate<E1, E2> predicate : this.predicates) {
            if (!predicate.test(first, second)) continue;
            return true;
        }
        return false;
    }
}

