/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.consumers;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.tuples.Pair;

public class ConsumeIntoMap<K, V, M extends Map<K, V>>
implements Function<Iterator<Pair<K, V>>, M> {
    private final Supplier<M> supplier;

    public ConsumeIntoMap(Supplier<M> supplier) {
        dbc.precondition(supplier != null, "collection supplier cannot be null", new Object[0]);
        this.supplier = supplier;
    }

    @Override
    public M apply(Iterator<Pair<K, V>> consumable) {
        dbc.precondition(consumable != null, "consuming a null iterator", new Object[0]);
        Map out = (Map)this.supplier.get();
        while (consumable.hasNext()) {
            Pair<K, V> pair = consumable.next();
            out.put(pair.first(), pair.second());
        }
        return (M)out;
    }
}

