/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.Compositions;
import net.emaze.dysfunctional.casts.Vary;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.windows.CenteredWindowIterator;
import net.emaze.dysfunctional.windows.PreciseWindowIterator;
import net.emaze.dysfunctional.windows.TrailsIterator;

public abstract class Windowing {
    public static <T> Iterator<List<T>> window(int windowSize, Iterator<T> iterator) {
        Supplier factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PreciseWindowIterator(iterator, windowSize, factory);
    }

    public static <T> Iterator<List<T>> window(int windowSize, Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot create a window iterator from a null iterable", new Object[0]);
        Supplier factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PreciseWindowIterator(iterable.iterator(), windowSize, factory);
    }

    public static <W extends Collection<T>, T> Iterator<W> window(int windowSize, Iterator<T> iterator, Supplier<W> supplier) {
        return new PreciseWindowIterator<W, T>(iterator, windowSize, supplier);
    }

    public static <W extends Collection<T>, T> Iterator<W> window(int windowSize, Iterable<T> iterable, Supplier<W> supplier) {
        dbc.precondition(iterable != null, "cannot create a window iterator from a null iterable", new Object[0]);
        return new PreciseWindowIterator<W, T>(iterable.iterator(), windowSize, supplier);
    }

    public static <T> Iterator<List<Optional<T>>> centered(int windowSize, Iterator<T> iterator) {
        Supplier factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new CenteredWindowIterator(iterator, windowSize, factory);
    }

    public static <T> Iterator<List<Optional<T>>> centered(int windowSize, Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot create a centered window iterator from a null iterable", new Object[0]);
        Supplier factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new CenteredWindowIterator(iterable.iterator(), windowSize, factory);
    }

    public static <W extends Collection<Optional<T>>, T> Iterator<W> centered(int windowSize, Iterator<T> iterator, Supplier<W> supplier) {
        return new CenteredWindowIterator<W, T>(iterator, windowSize, supplier);
    }

    public static <W extends Collection<Optional<T>>, T> Iterator<W> centered(int windowSize, Iterable<T> iterable, Supplier<W> supplier) {
        dbc.precondition(iterable != null, "cannot create a centered window iterator from a null iterable", new Object[0]);
        return new CenteredWindowIterator<W, T>(iterable.iterator(), windowSize, supplier);
    }

    public static <T> Iterator<Queue<Optional<T>>> trails(int trailSize, Iterator<T> iterator) {
        return new TrailsIterator(iterator, trailSize, Function.identity());
    }

    public static <T, W extends Collection<?>> Iterator<W> trails(int trailSize, Iterator<T> iterator, Function<Queue<Optional<T>>, W> copy) {
        return new TrailsIterator<T, W>(iterator, trailSize, copy);
    }

    public static <T> Iterator<Queue<Optional<T>>> trails(int trailSize, Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot create a trails iterator from a null iterable", new Object[0]);
        return new TrailsIterator(iterable.iterator(), trailSize, Function.identity());
    }

    public static <T, W extends Collection<?>> Iterator<W> trails(int trailSize, Iterable<T> iterable, Function<Queue<Optional<T>>, W> copy) {
        dbc.precondition(iterable != null, "cannot create a trails iterator from a null iterable", new Object[0]);
        return new TrailsIterator<T, W>(iterable.iterator(), trailSize, copy);
    }
}

